/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.receita;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.empresa.EmpresaModelo;
import br.com.salomaotech.genesys.model.empresa.EmpresaPesquisa;
import br.com.salomaotech.genesys.model.empresa.ImagemEmpresa;
import br.com.salomaotech.genesys.model.receita.ReceitaModelo;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import br.com.salomaotech.sistema.algoritmos.GerarPdf3;
import br.com.salomaotech.sistema.jpa.Repository;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import java.io.File;
import javax.swing.JOptionPane;

public class ReceitaGeraPdf {
    private final GerarPdf3 gerarPdf3;
    private final EmpresaModelo empresaModelo = EmpresaPesquisa.getDadosEmpresa();
    private final ReceitaModelo receitaModelo;
    private final ClienteModelo clienteModelo;
    private final String pathDestino;
    private final Font fonteCorpo = new Font(Font.FontFamily.COURIER, 12.0f, 0);
    private final Image imagemLogotipo;

    public ReceitaGeraPdf(String pathDestino, long idReceita) {
        this.pathDestino = pathDestino + "receita_" + idReceita;
        this.gerarPdf3 = new GerarPdf3(this.pathDestino);
        this.receitaModelo = (ReceitaModelo)new Repository(new ReceitaModelo()).findById(idReceita);
        this.clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(this.receitaModelo.getIdCliente());
        this.imagemLogotipo = ImagemEmpresa.getImagemLogotipo(String.valueOf(this.empresaModelo.getId()));
    }

    public void addEmpresaTopo() {
        Paragraph paragrafoTitulo = new Paragraph();
        Chunk textoTitulo = new Chunk("Receitu\u00e1rio", new Font(Font.FontFamily.COURIER, 22.0f, 1));
        if (this.imagemLogotipo != null) {
            Paragraph paragraphImagem = new Paragraph();
            paragraphImagem.add(new Chunk(this.imagemLogotipo, 0.0f, -90.0f));
            paragraphImagem.setAlignment(0);
            this.gerarPdf3.addConteudo(paragraphImagem);
            Font fonteInfo = new Font(Font.FontFamily.COURIER, 12.0f, 1);
            Paragraph paragraphEmpresa = new Paragraph("Cl\u00ednica: " + this.empresaModelo.getNome() + "   Fone: " + this.empresaModelo.getTelefone(), fonteInfo);
            paragraphEmpresa.setAlignment(2);
            this.gerarPdf3.addConteudo(paragraphEmpresa);
            textoTitulo.setTextRise(-20.0f);
            paragrafoTitulo.add(textoTitulo);
            paragrafoTitulo.setAlignment(2);
        } else {
            Font fonteInfo = new Font(Font.FontFamily.COURIER, 14.0f, 1);
            Paragraph paragraphEmpresa = new Paragraph("Cl\u00ednica: " + this.empresaModelo.getNome() + "   Fone: " + this.empresaModelo.getTelefone(), fonteInfo);
            paragraphEmpresa.setAlignment(1);
            this.gerarPdf3.addConteudo(paragraphEmpresa);
            textoTitulo.setTextRise(-30.0f);
            paragrafoTitulo.add(textoTitulo);
            paragrafoTitulo.setAlignment(1);
        }
        this.gerarPdf3.addConteudo(paragrafoTitulo);
    }

    public void addPacienteTopo() {
        if (this.imagemLogotipo != null) {
            this.gerarPdf3.addConteudo(new Paragraph("\n\n\n\n"));
        } else {
            this.gerarPdf3.addConteudo(new Paragraph("\n\n\n"));
        }
        String dadosPaciente = "Paciente: " + this.clienteModelo.getNome() + "";
        Font fonteCorpoBold = new Font(this.fonteCorpo.getFamily(), this.fonteCorpo.getSize(), 1);
        this.gerarPdf3.addConteudo(new Paragraph(dadosPaciente, fonteCorpoBold));
        this.gerarPdf3.addConteudo(new Paragraph("\n\n"));
    }

    private void addReceita() {
        String medicamento = "" + this.receitaModelo.getMedicamento() + " (" + this.receitaModelo.getQuantidade() + " " + this.receitaModelo.getMedida() + ")";
        this.gerarPdf3.addConteudo(new Paragraph(medicamento, new Font(Font.FontFamily.HELVETICA, 11.0f, 1)));
        this.gerarPdf3.addConteudo(new Paragraph(this.receitaModelo.getPosologia(), new Font(Font.FontFamily.HELVETICA, 11.0f, 0)));
    }

    private void addRodape() {
        String assinaturaProfissional = "Profissional, ______________________________________________\n\n" + this.empresaModelo.getNome();
        Paragraph assinaturaProfissionalParagraph = new Paragraph(assinaturaProfissional, new Font(Font.FontFamily.HELVETICA, 11.0f, 0));
        assinaturaProfissionalParagraph.setAlignment(1);
        String dataBr = Datas.calendarParaStringBr(this.receitaModelo.getData());
        Paragraph dataParagraph = new Paragraph(dataBr, new Font(Font.FontFamily.HELVETICA, 11.0f, 0));
        dataParagraph.setAlignment(1);
        for (int i = 0; i <= 18; ++i) {
            this.gerarPdf3.addConteudo(new Paragraph("\n"));
        }
        this.gerarPdf3.addConteudo(assinaturaProfissionalParagraph);
        this.gerarPdf3.addConteudo(dataParagraph);
    }

    public boolean gerar() {
        this.addEmpresaTopo();
        this.addPacienteTopo();
        this.addReceita();
        this.addRodape();
        if (this.gerarPdf3.gerar()) {
            ExecutaProgramaExterno.executarModoDesktop(this.gerarPdf3.getPathDeSaidaDoArquivo());
            return true;
        }
        JOptionPane.showMessageDialog(null, "Falha ao gerar receita!");
        return false;
    }

    public boolean excluir() {
        try {
            return new File(this.pathDestino + ".pdf").delete();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

