/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.receita;

import br.com.salomaotech.genesys.model.receita.ReceitaModelo;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ReceitaPesquisa {
    private final JTable jTresultados;
    private final long idCliente;
    private final JComboBox jCpaginador;
    private Date data;

    public ReceitaPesquisa(JTable jTresultados, long idCliente, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.idCliente = idCliente;
        this.jCpaginador = jCpaginador;
    }

    public void setData(Date data) {
        this.data = data;
    }

    private void popularDados(List<ReceitaModelo> receitaModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (ReceitaModelo receitaModelo : receitaModeloList) {
            Object[] linhaDefaultTableModel = new Object[]{receitaModelo.getId(), Datas.calendarParaStringBr(receitaModelo.getData()), receitaModelo.getQuantidade(), receitaModelo.getMedida(), receitaModelo.getMedicamento(), receitaModelo.getPosologia()};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new ReceitaModelo());
        jpql.addParametroIgual("idCliente", this.idCliente);
        jpql.addOrderBy("data", "ASC");
        jpql.addOrderBy("id", "ASC");
        if (!Objects.isNull(this.data)) {
            jpql.addParametroIgual("data", this.data);
        }
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new ReceitaModelo());
        Repository repository = new Repository(new ReceitaModelo());
        List receitaModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(receitaModeloList);
    }
}

