/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.servico;

import br.com.salomaotech.genesys.model.servico.ServicoModelo;
import br.com.salomaotech.sistema.algoritmos.ConverteNumeroParaMoedaBr;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComboBox;

public class ComboBoxServico {
    private final JComboBox jComboBox;
    private long idServicoSelecionado = 0L;
    private List<ServicoModelo> servicoModeloList = new ArrayList<ServicoModelo>();
    private final LinkedHashMap cadastroDeServicosMap = new LinkedHashMap();

    public ComboBoxServico(JComboBox jComboBox) {
        this.jComboBox = jComboBox;
        this.addEventos();
    }

    private JPQL popularJpql() {
        JPQL jpql = new JPQL(new ServicoModelo());
        jpql.addOrderBy("nome", "ASC");
        return jpql;
    }

    private void addEventos() {
        this.jComboBox.addActionListener(e -> {
            try {
                this.idServicoSelecionado = (Long)this.cadastroDeServicosMap.get(this.jComboBox.getSelectedItem());
            }
            catch (Exception ex) {
                this.idServicoSelecionado = 0L;
            }
        });
    }

    private String getNomeServico(ServicoModelo servico) {
        return servico.getNome() + " - " + ConverteNumeroParaMoedaBr.converter(servico.getValor().toString());
    }

    public void preencher() {
        this.jComboBox.removeAllItems();
        this.jComboBox.addItem("");
        this.servicoModeloList = new Repository(new ServicoModelo()).getResults(this.popularJpql().construirSelect());
        this.servicoModeloList.forEach(servico -> {
            this.jComboBox.addItem(this.getNomeServico((ServicoModelo)servico));
            this.cadastroDeServicosMap.put(this.getNomeServico((ServicoModelo)servico), servico.getId());
        });
    }

    public void selecionarItemPorId(long idServico) {
        this.jComboBox.setSelectedItem("");
        this.servicoModeloList = new Repository(new ServicoModelo()).getResults(this.popularJpql().construirSelect());
        this.servicoModeloList.forEach(servico -> {
            if (servico.getId() == idServico) {
                this.jComboBox.setSelectedItem(this.getNomeServico((ServicoModelo)servico));
                this.idServicoSelecionado = idServico;
            }
        });
    }

    public long getIdSelecionado() {
        return this.idServicoSelecionado;
    }
}

