/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.servico;

import br.com.salomaotech.genesys.model.servico.ServicoModelo;
import br.com.salomaotech.sistema.algoritmos.ConverteNumeroParaMoedaBr;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ServicoPesquisa {
    private final JTable jTresultados;
    private final JComboBox jCpaginador;
    private String nome;

    public ServicoPesquisa(JTable jTresultados, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.jCpaginador = jCpaginador;
    }

    private void popularDados(List<ServicoModelo> servicoModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (ServicoModelo servicoModelo : servicoModeloList) {
            Object[] linhaDefaultTableModel = new Object[]{servicoModelo.getId(), servicoModelo.getNome(), ConverteNumeroParaMoedaBr.converter(servicoModelo.getValor().toString()), servicoModelo.getCategoria(), servicoModelo.getNome()};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new ServicoModelo());
        jpql.addParametroLike("nome", this.nome);
        jpql.addOrderBy("nome", "ASC");
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new ServicoModelo());
        Repository repository = new Repository(new ServicoModelo());
        List servicoModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(servicoModeloList);
    }
}

