/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.tratamento;

import br.com.salomaotech.genesys.model.tratamento.TratamentoModeloItem;
import br.com.salomaotech.sistema.patterns.Modelo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class TratamentoModelo
implements Modelo,
Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Temporal(value=TemporalType.DATE)
    private Calendar data;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TratamentoModeloItem> tratamentoModeloItemList = new ArrayList<TratamentoModeloItem>();
    private boolean finalizado;
    @Lob
    private String observacao;
    private String formaPagamento;
    private long idCliente;
    private long idColaborador;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public Calendar getData() {
        return this.data;
    }

    public void setData(Calendar data) {
        this.data = data;
    }

    public List<TratamentoModeloItem> getTratamentoModeloItemList() {
        return this.tratamentoModeloItemList;
    }

    public void setTratamentoModeloItemList(List<TratamentoModeloItem> tratamentoModeloItemList) {
        this.tratamentoModeloItemList = tratamentoModeloItemList;
    }

    public boolean isFinalizado() {
        return this.finalizado;
    }

    public void setFinalizado(boolean finalizado) {
        this.finalizado = finalizado;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(String formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    public long getIdCliente() {
        return this.idCliente;
    }

    public void setIdCliente(long idCliente) {
        this.idCliente = idCliente;
    }

    public long getIdColaborador() {
        return this.idColaborador;
    }

    public void setIdColaborador(long idColaborador) {
        this.idColaborador = idColaborador;
    }

    public BigDecimal getValorTotal() {
        BigDecimal valorResultado = new BigDecimal(0);
        for (TratamentoModeloItem tratamentoModeloItem : this.tratamentoModeloItemList) {
            valorResultado = valorResultado.add(tratamentoModeloItem.getValor());
        }
        return valorResultado;
    }
}

