/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.tratamento;

import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModelo;
import br.com.salomaotech.sistema.algoritmos.ConverteNumeroParaMoedaBr;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class TratamentoPesquisa {
    private final JTable jTresultados;
    private final long idCliente;
    private final JComboBox jCpaginador;
    private Date data;
    private String finalizado;
    private long idColaborador;

    public TratamentoPesquisa(JTable jTresultados, long idCliente, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.idCliente = idCliente;
        this.jCpaginador = jCpaginador;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void setFinalizado(String finalizado) {
        this.finalizado = finalizado;
    }

    public void setIdColaborador(long idColaborador) {
        this.idColaborador = idColaborador;
    }

    private void popularDados(List<TratamentoModelo> tratamentoModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (TratamentoModelo tratamentoModelo : tratamentoModeloList) {
            String nomeColaborador = "";
            String statusFinalizado = tratamentoModelo.isFinalizado() ? "Sim" : "Nao";
            if (tratamentoModelo.getIdColaborador() > 0L) {
                ColaboradorModelo colaboradorModelo = (ColaboradorModelo)new Repository(new ColaboradorModelo()).findById(tratamentoModelo.getIdColaborador());
                nomeColaborador = colaboradorModelo.getNome();
            }
            Object[] linhaDefaultTableModel = new Object[]{tratamentoModelo.getId(), Datas.calendarParaStringBr(tratamentoModelo.getData()), ConverteNumeroParaMoedaBr.converter(tratamentoModelo.getValorTotal().toString()), nomeColaborador, statusFinalizado};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new TratamentoModelo());
        jpql.addParametroIgual("idCliente", this.idCliente);
        jpql.addOrderBy("data", "ASC");
        jpql.addOrderBy("id", "ASC");
        if (!Objects.isNull(this.data)) {
            jpql.addParametroIgual("data", this.data);
        }
        if (this.idColaborador > 0L) {
            jpql.addParametroIgual("idColaborador", this.idColaborador);
        }
        if (!Objects.isNull(this.finalizado) && !this.finalizado.equals("Todos")) {
            jpql.addParametroIgual("finalizado", this.finalizado.equals("Sim"));
        }
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new TratamentoModelo());
        Repository repository = new Repository(new TratamentoModelo());
        List tratamentoModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(tratamentoModeloList);
    }
}

