/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.genesys.model.tratamento.pesquisa_avancada;

import br.com.salomaotech.genesys.model.cliente.ClienteModelo;
import br.com.salomaotech.genesys.model.colaborador.ColaboradorModelo;
import br.com.salomaotech.genesys.model.tratamento.TratamentoModelo;
import br.com.salomaotech.sistema.algoritmos.ConverteNumeroParaMoedaBr;
import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.jpa.Paginador;
import br.com.salomaotech.sistema.jpa.Repository;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class TratamentoPesquisaAvancada {
    private final JTable jTresultados;
    private final JComboBox jCpaginador;
    private Date dataInicialDate;
    private Date dataFinalDate;
    private String finalizado;
    private long idColaborador;
    private long idCliente;

    public TratamentoPesquisaAvancada(JTable jTresultados, JComboBox jCpaginador) {
        this.jTresultados = jTresultados;
        this.jCpaginador = jCpaginador;
    }

    public void setDataInicialDate(Date dataInicialDate) {
        this.dataInicialDate = dataInicialDate;
    }

    public void setDataFinalDate(Date dataFinalDate) {
        this.dataFinalDate = dataFinalDate;
    }

    public void setFinalizado(String finalizado) {
        this.finalizado = finalizado;
    }

    public void setIdColaborador(long idColaborador) {
        this.idColaborador = idColaborador;
    }

    public void setIdCliente(long idCliente) {
        this.idCliente = idCliente;
    }

    private void popularDados(List<TratamentoModelo> tratamentoModeloList) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTresultados.getModel();
        defaultTableModel.setNumRows(0);
        int contador = 0;
        for (TratamentoModelo tratamentoModelo : tratamentoModeloList) {
            String nomeColaborador = "";
            String nomeCliente = "";
            String statusFinalizado = tratamentoModelo.isFinalizado() ? "Sim" : "Nao";
            if (tratamentoModelo.getIdColaborador() > 0L) {
                ColaboradorModelo colaboradorModelo = (ColaboradorModelo)new Repository(new ColaboradorModelo()).findById(tratamentoModelo.getIdColaborador());
                nomeColaborador = colaboradorModelo.getNome();
            }
            if (tratamentoModelo.getIdCliente() > 0L) {
                ClienteModelo clienteModelo = (ClienteModelo)new Repository(new ClienteModelo()).findById(tratamentoModelo.getIdCliente());
                nomeCliente = clienteModelo.getNome();
            }
            Object[] linhaDefaultTableModel = new Object[]{tratamentoModelo.getId(), Datas.calendarParaStringBr(tratamentoModelo.getData()), nomeColaborador, nomeCliente, ConverteNumeroParaMoedaBr.converter(tratamentoModelo.getValorTotal().toString()), statusFinalizado};
            defaultTableModel.insertRow(contador, linhaDefaultTableModel);
            ++contador;
        }
    }

    public void pesquisar() {
        JPQL jpql = new JPQL(new TratamentoModelo());
        jpql.addOrderBy("data", "ASC");
        jpql.addOrderBy("id", "ASC");
        if (!Objects.isNull(this.dataInicialDate) && !Objects.isNull(this.dataFinalDate)) {
            jpql.addParametroMaiorIgual("data", this.dataInicialDate);
            jpql.addParametroMenorIgual("data", this.dataFinalDate);
        } else {
            if (!Objects.isNull(this.dataInicialDate)) {
                jpql.addParametroIgual("data", this.dataInicialDate);
            }
            if (!Objects.isNull(this.dataFinalDate)) {
                jpql.addParametroMenorIgual("data", this.dataFinalDate);
            }
        }
        if (this.idColaborador > 0L) {
            jpql.addParametroIgual("idColaborador", this.idColaborador);
        }
        if (this.idCliente > 0L) {
            jpql.addParametroIgual("idCliente", this.idCliente);
        }
        if (!Objects.isNull(this.finalizado) && !this.finalizado.equals("Todos")) {
            jpql.addParametroIgual("finalizado", this.finalizado.equals("Sim"));
        }
        Paginador paginador = new Paginador(jpql, this.jCpaginador, new TratamentoModelo());
        Repository repository = new Repository(new TratamentoModelo());
        List tratamentoModeloList = repository.getResultsComPaginador(jpql.construirSelect(), paginador.getPageNumber(), paginador.getPageSize());
        this.popularDados(tratamentoModeloList);
    }
}

