/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.modelos.ApiModelo;
import br.com.salomaotech.sistema.patterns.Command;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.swing.SwingUtilities;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ApiClient {
    public static void processApiData(String apiUrl, final Command command) {
        final OkHttpClient httpClient = new OkHttpClient();
        Request request = new Request.Builder().url(apiUrl).build();
        httpClient.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                httpClient.dispatcher().executorService().shutdown();
            }

            @Override
            public void onResponse(Call call, Response response) {
                try (ResponseBody responseBody = response.body();){
                    ApiModelo api = new ObjectMapper().readValue(responseBody.string(), ApiModelo.class);
                    SwingUtilities.invokeLater(() -> {
                        command.executar(api);
                        httpClient.dispatcher().executorService().shutdown();
                    });
                }
                catch (IOException e) {
                    httpClient.dispatcher().executorService().shutdown();
                }
            }
        });
    }
}

