/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import br.com.salomaotech.sistema.algoritmos.CriaPastaLocal;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CopiaArquivosComDialogo {
    private final JFileChooser jFileChooser;
    private FileNameExtensionFilter filtro;
    private final String pathDestino;
    private final boolean isSelecionarMultiplos;
    private final List listaDeArquivosCopiados = new ArrayList();

    public CopiaArquivosComDialogo(String pathDestino, boolean isSelecionarMultiplos) {
        pathDestino = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathDestino);
        CriaPastaLocal.criar(pathDestino);
        this.pathDestino = pathDestino;
        this.isSelecionarMultiplos = isSelecionarMultiplos;
        this.jFileChooser = new JFileChooser();
        this.jFileChooser.setMultiSelectionEnabled(isSelecionarMultiplos);
    }

    public void setFiltro(FileNameExtensionFilter filtro) {
        this.filtro = filtro;
    }

    public boolean copiar() {
        int numeroDeFalhas = 0;
        if (!Objects.isNull(this.filtro)) {
            this.jFileChooser.addChoosableFileFilter(this.filtro);
            this.jFileChooser.setFileFilter(this.filtro);
        }
        if (this.jFileChooser.showOpenDialog(null) == 0 & !ValidaStringIsEmpty.isEmpty(this.pathDestino)) {
            if (this.isSelecionarMultiplos) {
                for (File arquivo : this.jFileChooser.getSelectedFiles()) {
                    try {
                        String destinoFinalDoArquivo = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(this.pathDestino + "/" + arquivo.getName());
                        Files.copy(arquivo.toPath(), new File(destinoFinalDoArquivo).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        this.listaDeArquivosCopiados.add(destinoFinalDoArquivo);
                    }
                    catch (IOException ex) {
                        ++numeroDeFalhas;
                    }
                }
            } else {
                try {
                    File arquivo = this.jFileChooser.getSelectedFile();
                    String destinoFinalDoArquivo = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(this.pathDestino + "/" + arquivo.getName());
                    Files.copy(arquivo.toPath(), new File(destinoFinalDoArquivo).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.listaDeArquivosCopiados.add(destinoFinalDoArquivo);
                }
                catch (IOException ex) {
                    ++numeroDeFalhas;
                }
            }
        } else {
            ++numeroDeFalhas;
        }
        return numeroDeFalhas == 0;
    }

    public List<String> getListaDeArquivosCopiados() {
        return this.listaDeArquivosCopiados;
    }
}

