/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import com.toedter.calendar.JCalendar;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class Datas {
    public static String calendarParaStringBr(Calendar calendar) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            return formatter.format(calendar.getTime());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String localDateParaStringBr(LocalDate localDate) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            return localDate.format(formatter);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Calendar adicionarMesCalendar(Calendar calendar, int numeroMesesAdicionar) {
        try {
            Calendar novoCalendar = (Calendar)calendar.clone();
            novoCalendar.add(2, numeroMesesAdicionar);
            return novoCalendar;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isCalendarioValido(Calendar calendar) {
        try {
            boolean isAnoValido = calendar.get(1) >= 1 && calendar.get(1) <= 9998;
            boolean isMesValido = calendar.get(2) >= 0 && calendar.get(2) <= 11;
            boolean isDiaValido = calendar.get(5) >= 1 && calendar.get(5) <= 31;
            return isAnoValido && isMesValido && isDiaValido;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isObjetoData(Object object) {
        ArrayList<String> tiposValidos = new ArrayList<String>();
        tiposValidos.add("com.toedter.calendar.JCalendar");
        tiposValidos.add("java.util.GregorianCalendar");
        tiposValidos.add("java.util.Date");
        return tiposValidos.contains(object.getClass().getName());
    }

    public static String calendarParaStringAnoMesDia(Object valor) {
        Date data = null;
        switch (valor.getClass().getName()) {
            case "com.toedter.calendar.JCalendar": {
                JCalendar jCalendar = (JCalendar)valor;
                data = jCalendar.getCalendar().getTime();
                break;
            }
            case "java.util.GregorianCalendar": {
                Calendar calendar = (Calendar)valor;
                data = calendar.getTime();
                break;
            }
            case "java.util.Date": {
                data = (Date)valor;
            }
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd").format(data);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String localTimeParaStringBr(LocalTime localTime) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
            return localTime.format(formatter);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

