/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ExecutaProgramaExterno {
    public static boolean executarModoDesktop(String enderecoDoPrograma) {
        try {
            enderecoDoPrograma = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(enderecoDoPrograma);
            if (new File(enderecoDoPrograma).exists()) {
                Desktop desktop = Desktop.getDesktop();
                File meuArquivo = new File(enderecoDoPrograma);
                desktop.open(meuArquivo);
                return true;
            }
            return false;
        }
        catch (IOException | NullPointerException ex) {
            return false;
        }
    }

    public static boolean executarModoJar(String enderecoDoPrograma, Object parametro) {
        try {
            enderecoDoPrograma = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(enderecoDoPrograma);
            if (new File(enderecoDoPrograma).exists()) {
                Path pastaDoPrograma = Paths.get(enderecoDoPrograma, new String[0]);
                File arquivo = new File(pastaDoPrograma.getParent().toString());
                String comandoExecutar = "java -jar " + pastaDoPrograma.getFileName() + " " + parametro;
                Runtime.getRuntime().exec(comandoExecutar, null, arquivo);
                return true;
            }
            return false;
        }
        catch (IOException | NullPointerException ex) {
            return false;
        }
    }

    public static boolean abreUrlNoBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            return true;
        }
        catch (IOException | URISyntaxException ex) {
            return false;
        }
    }
}

