/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import br.com.salomaotech.sistema.algoritmos.CriaPastaLocal;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GerarPdf {
    private final String pathDeSaidaDoArquivo;
    private final List conteudoDoCorpoDoDocumento = new ArrayList();
    private Document document;
    private int largura = 257;
    private int altura = 400;
    private final int margemEsquerda = 8;
    private final int margemDireita = 0;
    private final int margemTopo = 5;
    private final int margemRodape = 5;

    public GerarPdf(String pathDeSaidaDoArquivo) {
        this.pathDeSaidaDoArquivo = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathDeSaidaDoArquivo + ".pdf");
    }

    public void setLargura(int largura) {
        this.largura = largura;
    }

    public void setAltura(int altura) {
        this.altura = altura;
    }

    public String getPathDeSaidaDoArquivo() {
        return this.pathDeSaidaDoArquivo;
    }

    public void addConteudo(String conteudo) {
        this.conteudoDoCorpoDoDocumento.add(conteudo);
    }

    public void addConteudo(PdfPTable pdfPTable) {
        this.conteudoDoCorpoDoDocumento.add(pdfPTable);
    }

    public boolean gerar() {
        try {
            this.document = new Document(new Rectangle(this.largura, this.altura), 8.0f, 0.0f, 5.0f, 5.0f);
            CriaPastaLocal.criar(new File(this.pathDeSaidaDoArquivo).getParent());
            PdfWriter.getInstance(this.document, new FileOutputStream(this.pathDeSaidaDoArquivo));
            this.document.open();
            this.conteudoDoCorpoDoDocumento.forEach(linha -> {
                try {
                    switch (linha.getClass().getName()) {
                        case "java.lang.String": {
                            this.document.add(new Paragraph((String)linha, new Font(Font.FontFamily.COURIER, 8.0f, 0)));
                            break;
                        }
                        case "com.itextpdf.text.pdf.PdfPTable": {
                            this.document.add((PdfPTable)linha);
                        }
                    }
                }
                catch (DocumentException | NullPointerException exception) {
                    // empty catch block
                }
            });
            this.document.close();
            return new File(this.pathDeSaidaDoArquivo).exists();
        }
        catch (DocumentException | IOException | NullPointerException ex) {
            return false;
        }
    }
}

