/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import br.com.salomaotech.sistema.algoritmos.CriaPastaLocal;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GerarPdf2 {
    private final String pathDeSaidaDoArquivo;
    private final List<Paragraph> conteudoDoCorpoDoDocumento = new ArrayList<Paragraph>();
    private final Document document = new Document();

    public GerarPdf2(String pathDeSaidaDoArquivo) {
        this.pathDeSaidaDoArquivo = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathDeSaidaDoArquivo + ".pdf");
    }

    public String getPathDeSaidaDoArquivo() {
        return this.pathDeSaidaDoArquivo;
    }

    public void addConteudo(Paragraph paragrafo) {
        this.conteudoDoCorpoDoDocumento.add(paragrafo);
    }

    public boolean gerar() {
        try {
            CriaPastaLocal.criar(new File(this.pathDeSaidaDoArquivo).getParent());
            PdfWriter.getInstance(this.document, new FileOutputStream(this.pathDeSaidaDoArquivo));
            this.document.open();
            this.conteudoDoCorpoDoDocumento.forEach(paragrafo -> {
                try {
                    this.document.add((Element)paragrafo);
                }
                catch (DocumentException | NullPointerException exception) {
                    // empty catch block
                }
            });
            this.document.close();
            return new File(this.pathDeSaidaDoArquivo).exists();
        }
        catch (DocumentException | IOException | NullPointerException ex) {
            return false;
        }
    }
}

