/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import br.com.salomaotech.sistema.algoritmos.CriaPastaLocal;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GerarPdf3 {
    private final String pathDeSaidaDoArquivo;
    private final List<Paragraph> conteudoTexto = new ArrayList<Paragraph>();
    private final List<PdfPTable> conteudoTabela = new ArrayList<PdfPTable>();
    private final Document document = new Document();

    public GerarPdf3(String pathDeSaidaDoArquivo) {
        this.pathDeSaidaDoArquivo = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathDeSaidaDoArquivo + ".pdf");
    }

    public String getPathDeSaidaDoArquivo() {
        return this.pathDeSaidaDoArquivo;
    }

    public void addConteudo(Paragraph paragrafo) {
        this.conteudoTexto.add(paragrafo);
    }

    public void addTabela(String[][] dados, Font font) {
        if (dados.length == 0 || dados[0].length == 0) {
            return;
        }
        PdfPTable tabela = new PdfPTable(dados[0].length);
        tabela.setHorizontalAlignment(0);
        tabela.setWidthPercentage(100.0f);
        String[][] stringArray = dados;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] linha;
            for (String celula : linha = stringArray[i]) {
                PdfPCell cell = new PdfPCell(new Phrase(celula, font));
                tabela.addCell(cell);
            }
        }
        this.conteudoTabela.add(tabela);
    }

    public boolean gerar() {
        try {
            CriaPastaLocal.criar(new File(this.pathDeSaidaDoArquivo).getParent());
            PdfWriter.getInstance(this.document, new FileOutputStream(this.pathDeSaidaDoArquivo));
            this.document.open();
            for (Paragraph paragrafo : this.conteudoTexto) {
                this.document.add(paragrafo);
            }
            for (PdfPTable tabela : this.conteudoTabela) {
                this.document.add(tabela);
            }
            this.document.close();
            return new File(this.pathDeSaidaDoArquivo).exists();
        }
        catch (DocumentException | IOException ex) {
            return false;
        }
    }
}

