/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import br.com.salomaotech.sistema.algoritmos.ExecutaProgramaExterno;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImagemExibe {
    private final JPanel painel;
    private final int largura;
    private final int altura;

    public ImagemExibe(JPanel painel, int largura, int altura) {
        this.painel = painel;
        this.largura = largura;
        this.altura = altura;
    }

    private void addEvento(Component elemento, final String pathImagem) {
        elemento.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    ExecutaProgramaExterno.executarModoDesktop(pathImagem);
                }
            }
        });
    }

    public boolean exibir(String pathImagem) {
        Image imagem;
        if (Objects.isNull(pathImagem)) {
            return false;
        }
        pathImagem = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathImagem);
        try {
            imagem = new ImageIcon(new URL(pathImagem)).getImage().getScaledInstance(this.largura, this.altura, 4);
        }
        catch (MalformedURLException ex) {
            if (new File(pathImagem).exists()) {
                imagem = new ImageIcon(pathImagem).getImage().getScaledInstance(this.largura, this.altura, 4);
            }
            return false;
        }
        JLabel elemento = new JLabel(new ImageIcon(imagem));
        elemento.setLocation(5, 5);
        elemento.setSize(this.largura, this.altura);
        this.painel.removeAll();
        this.painel.add(elemento);
        this.painel.repaint();
        this.addEvento(elemento, pathImagem);
        return true;
    }
}

