/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.algoritmos;

import br.com.salomaotech.sistema.algoritmos.CaminhoArquivoNormalizado;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;

public class ImagemRedimensiona {
    private final String pathOrigem;
    private final String pathDestino;
    private final int tamanho;

    public ImagemRedimensiona(String pathOrigem, String pathDestino, int tamanho) {
        this.pathOrigem = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathOrigem);
        this.pathDestino = CaminhoArquivoNormalizado.obterCaminhoArquivoNormalizado(pathDestino);
        this.tamanho = tamanho;
    }

    public boolean redimensionar() {
        try {
            BufferedImage bufferedImage;
            File arquivo = new File(this.pathOrigem);
            if (arquivo.getName().lastIndexOf(46) > 0) {
                String extensao = arquivo.getName().substring(arquivo.getName().lastIndexOf(46) + 1);
                BufferedImage imagemOriginal = ImageIO.read(arquivo);
                BufferedImage miniatura = Scalr.resize(imagemOriginal, Scalr.Method.AUTOMATIC, Scalr.Mode.AUTOMATIC, this.tamanho, Scalr.OP_ANTIALIAS);
                ImageIO.write((RenderedImage)miniatura, extensao, new File(this.pathDestino));
            }
            return (bufferedImage = ImageIO.read(new File(this.pathDestino))).getWidth() == this.tamanho || bufferedImage.getHeight() == this.tamanho;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

