/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.jpa;

import br.com.salomaotech.sistema.jpa.ConexaoSingleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;

public class Dao<E> {
    private final Class nomeTabela;
    private final ConexaoSingleton conexaoSingleton;
    private final String objetoDados = "objeto";

    public Dao(Class nomeTabela, ConexaoSingleton conexaoSingleton) {
        this.nomeTabela = nomeTabela;
        this.conexaoSingleton = conexaoSingleton;
    }

    public void create(E entidade) {
        try {
            EntityManager entityManager = this.conexaoSingleton.getEntityManager();
            EntityTransaction entityTransaction = entityManager.getTransaction();
            entityTransaction.begin();
            entityManager.persist(entidade);
            entityTransaction.commit();
            entityManager.refresh(entidade);
            entityManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(E entidade) {
        try {
            EntityManager entityManager = this.conexaoSingleton.getEntityManager();
            EntityTransaction entityTransaction = entityManager.getTransaction();
            entityTransaction.begin();
            entityManager.merge(entidade);
            entityTransaction.commit();
            entityManager.refresh(entidade);
            entityManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void delete(Long id) {
        try {
            EntityManager entityManager = this.conexaoSingleton.getEntityManager();
            EntityTransaction entityTransaction = entityManager.getTransaction();
            entityTransaction.begin();
            entityManager.remove(entityManager.find(this.nomeTabela, id));
            entityTransaction.commit();
            entityManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public E findById(Long id) {
        E entidadeRetorno = null;
        try {
            EntityManager entityManager = this.conexaoSingleton.getEntityManager();
            entidadeRetorno = (E)entityManager.find(this.nomeTabela, id);
            entityManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entidadeRetorno;
    }

    public List findBySqlQuery(String sqlParametros, int pageNumber, int pageSize) {
        List<Object> EntidadesRetorno = new ArrayList();
        try {
            EntityManager entityManager = this.conexaoSingleton.getEntityManager();
            TypedQuery query = entityManager.createQuery(sqlParametros, this.nomeTabela);
            if (pageNumber > 0) {
                query.setFirstResult((pageNumber - 1) * pageSize);
            }
            if (pageSize > 0) {
                query.setMaxResults(pageSize);
            }
            EntidadesRetorno = query.getResultList();
            entityManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EntidadesRetorno;
    }

    public List findTodos() {
        return this.findBySqlQuery("SELECT objeto FROM " + this.nomeTabela.getSimpleName() + " " + "objeto", 0, 0);
    }

    public long countTodos(String condicaoSql) {
        long resultados = 0L;
        try {
            String sqlParametros = "SELECT COUNT(objeto.id) FROM " + this.nomeTabela.getSimpleName() + " " + "objeto";
            if (!Objects.isNull(condicaoSql)) {
                sqlParametros = sqlParametros + " " + condicaoSql;
            }
            EntityManager entityManager = this.conexaoSingleton.getEntityManager();
            resultados = entityManager.createQuery(sqlParametros, Long.class).getSingleResult();
            entityManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultados;
    }
}

