/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.jpa;

import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.algoritmos.ValidaStringIsEmpty;
import br.com.salomaotech.sistema.patterns.Modelo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JPQL {
    private final String nomeTabela;
    private final String objetoDadosDoSelect;
    private final List colunasPesquisar;
    private final List colunasOrdenar;

    public JPQL(Modelo modelo) {
        this.nomeTabela = modelo.getClass().getSimpleName();
        this.objetoDadosDoSelect = "objeto";
        this.colunasPesquisar = new ArrayList();
        this.colunasOrdenar = new ArrayList();
    }

    private String geraItemColunaPesquisa(String chave, Object valor, String clausulaInicio, String clausulaFim) {
        String apostofro = "'";
        boolean isString = false;
        switch (valor.getClass().getName()) {
            case "java.lang.Integer": {
                apostofro = "";
                break;
            }
            case "java.lang.Boolean": {
                apostofro = "";
                break;
            }
            case "java.lang.Long": {
                apostofro = "";
                break;
            }
            case "java.math.BigDecimal": {
                apostofro = "";
                break;
            }
            case "java.lang.String": {
                isString = true;
                break;
            }
            default: {
                if (!Datas.isObjetoData(valor)) break;
                valor = Datas.calendarParaStringAnoMesDia(valor);
            }
        }
        if (isString) {
            valor = valor.toString().toLowerCase();
            if (!Objects.isNull(clausulaInicio) && !Objects.isNull(clausulaFim)) {
                return "LOWER(" + this.objetoDadosDoSelect + "." + chave + ")" + clausulaInicio + "LOWER(" + apostofro + valor + apostofro + ")" + clausulaFim;
            }
            return "LOWER(" + this.objetoDadosDoSelect + "." + chave + ")" + clausulaInicio + "LOWER(" + apostofro + valor + apostofro + ")";
        }
        if (!Objects.isNull(clausulaInicio) && !Objects.isNull(clausulaFim)) {
            return this.objetoDadosDoSelect + "." + chave + clausulaInicio + valor + clausulaFim;
        }
        return this.objetoDadosDoSelect + "." + chave + clausulaInicio + apostofro + valor + apostofro;
    }

    private String constroiParametro(List tipoParametros, int tipoAcao) {
        String retorno = "";
        int contador = 0;
        for (Object parametro : tipoParametros) {
            if (contador > 0) {
                switch (tipoAcao) {
                    case 0: {
                        parametro = " AND " + parametro;
                        break;
                    }
                    case 1: {
                        parametro = ", " + parametro;
                    }
                }
            }
            retorno = retorno + parametro;
            ++contador;
        }
        return retorno;
    }

    public void addParametroIgual(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor)) {
            this.colunasPesquisar.add(this.geraItemColunaPesquisa(chave, valor, "=", null));
        }
    }

    public void addParametroDiferente(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor)) {
            this.colunasPesquisar.add(this.geraItemColunaPesquisa(chave, valor, "!=", null));
        }
    }

    public void addParametroLike(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor) && valor.getClass().getName().equals("java.lang.String")) {
            String condicao = this.geraItemColunaPesquisa(chave, valor, " LIKE ", null);
            String novoValor = String.valueOf(valor).toLowerCase();
            condicao = condicao.replace("LIKE LOWER('" + novoValor + "')", "LIKE LOWER('%" + novoValor + "%')");
            this.colunasPesquisar.add(condicao);
        }
    }

    public void addParametroNaoNulo(String chave) {
        if (!ValidaStringIsEmpty.isEmpty(chave)) {
            this.colunasPesquisar.add(this.objetoDadosDoSelect + "." + chave + " IS NOT NULL");
        }
    }

    public void addParametroNulo(String chave) {
        if (!ValidaStringIsEmpty.isEmpty(chave)) {
            this.colunasPesquisar.add(this.objetoDadosDoSelect + "." + chave + " IS NULL");
        }
    }

    public void addParametroMaiorIgual(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor)) {
            this.colunasPesquisar.add(this.geraItemColunaPesquisa(chave, valor, ">=", null));
        }
    }

    public void addParametroMenorIgual(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor)) {
            this.colunasPesquisar.add(this.geraItemColunaPesquisa(chave, valor, "<=", null));
        }
    }

    public void addParametroMenor(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor)) {
            this.colunasPesquisar.add(this.geraItemColunaPesquisa(chave, valor, "<", null));
        }
    }

    public void addParametroCompararDuasChaves(String chaveA, String chaveB, String clausula) {
        if (!(ValidaStringIsEmpty.isEmpty(chaveA) || ValidaStringIsEmpty.isEmpty(chaveB) || ValidaStringIsEmpty.isEmpty(clausula))) {
            this.colunasPesquisar.add(this.objetoDadosDoSelect + "." + chaveA + " " + clausula + " " + this.objetoDadosDoSelect + "." + chaveB);
        }
    }

    public void addOrderBy(String chave, Object valor) {
        if (!ValidaStringIsEmpty.isEmpty(chave) && !ValidaStringIsEmpty.isEmpty(valor)) {
            this.colunasOrdenar.add(this.objetoDadosDoSelect + "." + chave + " " + valor);
        }
    }

    public String getCondicaoWhere() {
        String condicaoWhere = "";
        if (!this.colunasPesquisar.isEmpty()) {
            condicaoWhere = condicaoWhere + " WHERE " + this.constroiParametro(this.colunasPesquisar, 0);
        }
        return condicaoWhere;
    }

    public String construirSelect() {
        String sqlParametros = "SELECT " + this.objetoDadosDoSelect + " FROM " + this.nomeTabela + " " + this.objetoDadosDoSelect + this.getCondicaoWhere();
        if (!this.colunasOrdenar.isEmpty()) {
            sqlParametros = sqlParametros + " ORDER BY " + this.constroiParametro(this.colunasOrdenar, 1);
        }
        return sqlParametros;
    }

    public String construirDelete() {
        String sqlParametros;
        if (!this.getCondicaoWhere().isEmpty()) {
            sqlParametros = "DELETE FROM " + this.nomeTabela + this.getCondicaoWhere();
            sqlParametros = sqlParametros.replace(this.objetoDadosDoSelect + ".", "");
        } else {
            sqlParametros = "DELETE FROM " + this.nomeTabela;
        }
        return sqlParametros;
    }

    public String construirSelectDistinct(String campo) {
        if (!ValidaStringIsEmpty.isEmpty(campo)) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT p FROM ");
            sql.append(this.nomeTabela);
            sql.append(" p WHERE p.id IN (SELECT MAX(p2.id) FROM ");
            sql.append(this.nomeTabela);
            sql.append(" p2 GROUP BY p2.");
            sql.append(campo);
            sql.append(") ORDER BY p.");
            sql.append(campo);
            sql.append(" ASC");
            return sql.toString();
        }
        return null;
    }

    public String getObjetoDadosDoSelect() {
        return this.objetoDadosDoSelect;
    }
}

