/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.jpa;

import br.com.salomaotech.sistema.algoritmos.Datas;
import br.com.salomaotech.sistema.jpa.ConexaoSingleton;
import br.com.salomaotech.sistema.jpa.Dao;
import br.com.salomaotech.sistema.jpa.JPQL;
import br.com.salomaotech.sistema.patterns.Modelo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;

public class Repository {
    private final ConexaoSingleton conexaoSingleton = new ConexaoSingleton();
    private final Modelo modelo;
    private final Dao dao;

    public Repository(Modelo modelo) {
        this.conexaoSingleton.abrirConexao("Conexao");
        this.modelo = modelo;
        this.dao = new Dao(modelo.getClass(), this.conexaoSingleton);
    }

    public long save() {
        if (this.modelo.getId() == 0L) {
            this.dao.create(this.modelo);
        } else {
            this.dao.update(this.modelo);
        }
        return this.modelo.getId();
    }

    public List getResults(String queryParam) {
        return this.dao.findBySqlQuery(queryParam, 0, 0);
    }

    public List getResultsComPaginador(String queryParam, int pageNumber, int pageSize) {
        return this.dao.findBySqlQuery(queryParam, pageNumber, pageSize);
    }

    public Modelo findById(long id) {
        Modelo modeloPesquisa = (Modelo)this.dao.findById(id);
        if (Objects.isNull(modeloPesquisa)) {
            try {
                modeloPesquisa = (Modelo)Class.forName(this.modelo.getClass().getName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return modeloPesquisa;
    }

    public boolean delete(long id) {
        if (Objects.isNull(this.dao.findById(id))) {
            return false;
        }
        this.dao.delete(id);
        return Objects.isNull(this.dao.findById(id));
    }

    public void deleteTodos() {
        List modeloList = this.dao.findTodos();
        modeloList.forEach(objeto -> this.dao.delete(objeto.getId()));
    }

    public long countTodos(String condicaoSql) {
        return this.dao.countTodos(condicaoSql);
    }

    private String tratarValorUpdate(Object valor) {
        String apostofro = "'";
        switch (valor.getClass().getName()) {
            case "java.lang.Integer": {
                apostofro = "";
                break;
            }
            case "java.lang.Boolean": {
                apostofro = "";
                break;
            }
            case "java.lang.Long": {
                apostofro = "";
                break;
            }
            default: {
                if (!Datas.isObjetoData(valor)) break;
                valor = Datas.calendarParaStringAnoMesDia(valor);
            }
        }
        return apostofro + valor + apostofro;
    }

    public int updateRegistros(Map<String, Object> dados, JPQL jpql) {
        if (Objects.isNull(jpql)) {
            return 0;
        }
        int linhasAfetadas = 0;
        try {
            EntityManager manager = this.conexaoSingleton.getEntityManager();
            EntityTransaction tx = manager.getTransaction();
            tx.begin();
            StringBuilder setClause = new StringBuilder();
            for (Map.Entry<String, Object> entry : dados.entrySet()) {
                if (setClause.length() > 0) {
                    setClause.append(", ");
                }
                if (Objects.isNull(entry.getValue())) {
                    setClause.append(entry.getKey()).append(" = ").append(entry.getValue());
                    continue;
                }
                String valor = this.tratarValorUpdate(entry.getValue());
                setClause.append(entry.getKey()).append(" = ").append(valor);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ").append(this.modelo.getClass().getSimpleName()).append(" AS ").append(jpql.getObjetoDadosDoSelect()).append(" SET ").append((CharSequence)setClause).append(jpql.getCondicaoWhere());
            Query query = manager.createQuery(sql.toString());
            linhasAfetadas = query.executeUpdate();
            tx.commit();
            manager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linhasAfetadas;
    }
}

