/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.swing;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public class Grafico {
    private String tituloTopo;
    private String tituloRodape;
    private String legendaEsquerda;
    private final DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private final Map categoriasMap = new HashMap();

    public void setTituloTopo(String tituloTopo) {
        this.tituloTopo = tituloTopo;
    }

    public void setTituloRodape(String tituloRodape) {
        this.tituloRodape = tituloRodape;
    }

    public void setLegendaEsquerda(String legendaEsquerda) {
        this.legendaEsquerda = legendaEsquerda;
    }

    public void addCategoria(BigDecimal valor, String chave) {
        if (!Objects.isNull(this.categoriasMap.get(chave))) {
            valor = valor.add((BigDecimal)this.categoriasMap.get(chave));
        }
        this.categoriasMap.put(chave, valor);
    }

    public ChartPanel construir() {
        this.categoriasMap.forEach((titulo, valor) -> this.dataset.addValue(new BigDecimal(String.valueOf(valor)), (Comparable)((Object)String.valueOf(titulo)), (Comparable)((Object)String.valueOf(titulo))));
        JFreeChart jFreeChart = ChartFactory.createBarChart3D(this.tituloTopo, this.tituloRodape, this.legendaEsquerda, this.dataset, PlotOrientation.VERTICAL, true, true, false);
        ChartPanel panel = new ChartPanel(jFreeChart);
        return panel;
    }
}

