/*
 * Decompiled with CFR 0.152.
 */
package br.com.salomaotech.sistema.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;

public class PopUp {
    private JPopupMenu pMenu;
    private Component componenteAtivo;
    private JMenuItem jMenuItemRecortar;
    private JMenuItem jMenuItemCopiar;
    private JMenuItem jMenuItemColar;
    private JMenuItem jMenuItemLimpar;

    public void adicionarMenu(final Component componente) {
        this.pMenu = new JPopupMenu();
        this.jMenuItemRecortar = new JMenuItem("Recortar");
        this.pMenu.add(this.jMenuItemRecortar);
        this.jMenuItemRecortar.addActionListener(arg0 -> {
            JTextComponent c = (JTextComponent)this.componenteAtivo;
            c.cut();
        });
        this.jMenuItemCopiar = new JMenuItem("Copiar");
        this.pMenu.add(new JSeparator());
        this.pMenu.add(this.jMenuItemCopiar);
        this.jMenuItemCopiar.addActionListener(arg0 -> {
            JTextComponent c = (JTextComponent)this.componenteAtivo;
            c.copy();
        });
        this.jMenuItemColar = new JMenuItem("Colar");
        this.pMenu.add(new JSeparator());
        this.pMenu.add(this.jMenuItemColar);
        this.jMenuItemColar.addActionListener(arg0 -> {
            JTextComponent c = (JTextComponent)this.componenteAtivo;
            c.paste();
        });
        this.jMenuItemLimpar = new JMenuItem("Limpar");
        this.pMenu.add(new JSeparator());
        this.pMenu.add(this.jMenuItemLimpar);
        this.jMenuItemLimpar.addActionListener(arg0 -> {
            JTextComponent c = (JTextComponent)this.componenteAtivo;
            c.setText(null);
            try {
                JFormattedTextField d = (JFormattedTextField)this.componenteAtivo;
                d.setValue(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        componente.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    componente.requestFocus();
                    PopUp.this.componenteAtivo = componente;
                    PopUp.this.pMenu.show(componente, e.getX(), e.getY());
                    JTextComponent c = (JTextComponent)componente;
                    PopUp.this.jMenuItemRecortar.setEnabled(!Objects.isNull(c.getSelectedText()));
                    PopUp.this.jMenuItemCopiar.setEnabled(!Objects.isNull(c.getSelectedText()));
                    PopUp.this.jMenuItemColar.setEnabled(PopUp.this.isStringNaClipBoard());
                    componente.requestFocus();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private boolean isStringNaClipBoard() {
        try {
            return !Objects.isNull(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor));
        }
        catch (UnsupportedFlavorException | IOException ex) {
            return false;
        }
    }

    public boolean isMenuPopUpAdicionado(Component componente) {
        for (MouseListener classe : componente.getMouseListeners()) {
            if (!classe.getClass().toString().contains("swing.PopUp")) continue;
            return true;
        }
        return false;
    }
}

