/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.parser.LineDashPattern;
import com.itextpdf.text.pdf.parser.Matrix;

public class GraphicsState {
    Matrix ctm;
    float characterSpacing;
    float wordSpacing;
    float horizontalScaling;
    float leading;
    CMapAwareDocumentFont font;
    float fontSize;
    int renderMode;
    float rise;
    boolean knockout;
    PdfName colorSpaceFill;
    PdfName colorSpaceStroke;
    BaseColor fillColor = BaseColor.BLACK;
    BaseColor strokeColor = BaseColor.BLACK;
    private float lineWidth;
    private int lineCapStyle;
    private int lineJoinStyle;
    private float miterLimit;
    private LineDashPattern lineDashPattern;

    public GraphicsState() {
        this.ctm = new Matrix();
        this.characterSpacing = 0.0f;
        this.wordSpacing = 0.0f;
        this.horizontalScaling = 1.0f;
        this.leading = 0.0f;
        this.font = null;
        this.fontSize = 0.0f;
        this.renderMode = 0;
        this.rise = 0.0f;
        this.knockout = true;
        this.colorSpaceFill = null;
        this.colorSpaceStroke = null;
        this.fillColor = null;
        this.strokeColor = null;
        this.lineWidth = 1.0f;
        this.lineCapStyle = 0;
        this.lineJoinStyle = 0;
        this.miterLimit = 10.0f;
    }

    public GraphicsState(GraphicsState source2) {
        this.ctm = source2.ctm;
        this.characterSpacing = source2.characterSpacing;
        this.wordSpacing = source2.wordSpacing;
        this.horizontalScaling = source2.horizontalScaling;
        this.leading = source2.leading;
        this.font = source2.font;
        this.fontSize = source2.fontSize;
        this.renderMode = source2.renderMode;
        this.rise = source2.rise;
        this.knockout = source2.knockout;
        this.colorSpaceFill = source2.colorSpaceFill;
        this.colorSpaceStroke = source2.colorSpaceStroke;
        this.fillColor = source2.fillColor;
        this.strokeColor = source2.strokeColor;
        this.lineWidth = source2.lineWidth;
        this.lineCapStyle = source2.lineCapStyle;
        this.lineJoinStyle = source2.lineJoinStyle;
        this.miterLimit = source2.miterLimit;
        if (source2.lineDashPattern != null) {
            this.lineDashPattern = new LineDashPattern(source2.lineDashPattern.getDashArray(), source2.lineDashPattern.getDashPhase());
        }
    }

    public Matrix getCtm() {
        return this.ctm;
    }

    public float getCharacterSpacing() {
        return this.characterSpacing;
    }

    public float getWordSpacing() {
        return this.wordSpacing;
    }

    public float getHorizontalScaling() {
        return this.horizontalScaling;
    }

    public float getLeading() {
        return this.leading;
    }

    public CMapAwareDocumentFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public float getRise() {
        return this.rise;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public PdfName getColorSpaceFill() {
        return this.colorSpaceFill;
    }

    public PdfName getColorSpaceStroke() {
        return this.colorSpaceStroke;
    }

    public BaseColor getFillColor() {
        return this.fillColor;
    }

    public BaseColor getStrokeColor() {
        return this.strokeColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineCapStyle() {
        return this.lineCapStyle;
    }

    public void setLineCapStyle(int lineCapStyle) {
        this.lineCapStyle = lineCapStyle;
    }

    public int getLineJoinStyle() {
        return this.lineJoinStyle;
    }

    public void setLineJoinStyle(int lineJoinStyle) {
        this.lineJoinStyle = lineJoinStyle;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float miterLimit) {
        this.miterLimit = miterLimit;
    }

    public LineDashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public void setLineDashPattern(LineDashPattern lineDashPattern) {
        this.lineDashPattern = new LineDashPattern(lineDashPattern.getDashArray(), lineDashPattern.getDashPhase());
    }
}

