/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.OutsideRangeForDataTypeException;
import org.apache.derby.client.am.SqlException;

final class CrossConverters {
    public static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final BigDecimal bdMaxByteValue__ = BigDecimal.valueOf(127L);
    private static final BigDecimal bdMinByteValue__ = BigDecimal.valueOf(-128L);
    private static final BigDecimal bdMaxShortValue__ = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue__ = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue__ = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue__ = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue__ = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue__ = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue__ = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue__ = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue__ = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue__ = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdZero__ = BigDecimal.valueOf(0L);
    private static final BigDecimal bdOne__ = BigDecimal.valueOf(1L);
    private final Agent agent_;

    CrossConverters(Agent agent) {
        this.agent_ = agent;
    }

    final Object setObject(int n, boolean bl) throws SqlException {
        short s = bl ? (short)1 : 0;
        switch (n) {
            case -7: 
            case 16: {
                return bl;
            }
            case 5: {
                return s;
            }
            case 4: {
                return (int)s;
            }
            case -5: {
                return (long)s;
            }
            case 7: {
                return Float.valueOf(s);
            }
            case 8: {
                return (double)s;
            }
            case 3: {
                return BigDecimal.valueOf(s);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(bl);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "boolean", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, byte by) throws SqlException {
        return this.setObject(n, (short)by);
    }

    final Object setObject(int n, short s) throws SqlException {
        switch (n) {
            case -7: 
            case 16: {
                return s != 0;
            }
            case 5: {
                return s;
            }
            case 4: {
                return (int)s;
            }
            case -5: {
                return (long)s;
            }
            case 7: {
                return Float.valueOf(s);
            }
            case 8: {
                return (double)s;
            }
            case 3: {
                return BigDecimal.valueOf(s);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(s);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "byte", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, int n2) throws SqlException {
        switch (n) {
            case -7: 
            case 16: {
                return n2 != 0;
            }
            case 5: {
                if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)n2;
            }
            case 4: {
                return n2;
            }
            case -5: {
                return (long)n2;
            }
            case 7: {
                return Float.valueOf(n2);
            }
            case 8: {
                return (double)n2;
            }
            case 3: {
                return BigDecimal.valueOf(n2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "int", ClientTypes.getTypeString(n));
    }

    final boolean setBooleanFromObject(Object object, int n) throws SqlException {
        switch (n) {
            case 5: {
                return this.getBooleanFromShort((Short)object);
            }
            case 4: {
                return this.getBooleanFromInt((Integer)object);
            }
            case -5: {
                return this.getBooleanFromLong(((BigInteger)object).longValue());
            }
            case 7: {
                return this.getBooleanFromFloat(((Float)object).floatValue());
            }
            case 8: {
                return this.getBooleanFromDouble((Double)object);
            }
            case 3: {
                return this.getBooleanFromLong(((BigDecimal)object).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getBooleanFromString((String)object);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, ClientTypes.getTypeString(n), "boolean");
    }

    final byte setByteFromObject(Object object, int n) throws SqlException {
        switch (n) {
            case 5: {
                return this.getByteFromShort((Short)object);
            }
            case 4: {
                return this.getByteFromInt((Integer)object);
            }
            case -5: {
                return this.getByteFromLong(((BigInteger)object).longValue());
            }
            case 7: {
                return this.getByteFromFloat(((Float)object).floatValue());
            }
            case 8: {
                return this.getByteFromDouble((Double)object);
            }
            case 3: {
                return this.getByteFromLong(((BigDecimal)object).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getByteFromString((String)object);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, ClientTypes.getTypeString(n), "byte");
    }

    final Object setObject(int n, long l) throws SqlException {
        switch (n) {
            case -7: 
            case 16: {
                return l != 0L;
            }
            case 5: {
                if (l > 32767L || l < -32768L) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)l;
            }
            case 4: {
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)l;
            }
            case -5: {
                return l;
            }
            case 7: {
                return Float.valueOf(l);
            }
            case 8: {
                return (double)l;
            }
            case 3: {
                return BigDecimal.valueOf(l);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(l);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "long", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, float f) throws SqlException {
        switch (n) {
            case -7: 
            case 16: {
                return f != 0.0f;
            }
            case 5: {
                if (f > 32767.0f || f < -32768.0f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)f;
            }
            case 4: {
                if (f > 2.1474836E9f || f < -2.1474836E9f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)f;
            }
            case -5: {
                if (f > 9.223372E18f || f < -9.223372E18f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return (long)f;
            }
            case 7: {
                if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf(f);
            }
            case 8: {
                if ((double)f == Double.POSITIVE_INFINITY || (double)f == Double.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return Double.valueOf(String.valueOf(f));
            }
            case 3: {
                return new BigDecimal(String.valueOf(f));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(f);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "float", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, double d) throws SqlException {
        switch (n) {
            case -7: 
            case 16: {
                return d != 0.0;
            }
            case 5: {
                if (d > 32767.0 || d < -32768.0) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)d;
            }
            case 4: {
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)d;
            }
            case -5: {
                if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return (long)d;
            }
            case 7: {
                if (d > 3.4028234663852886E38 || d < -3.4028234663852886E38) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf((float)d);
            }
            case 8: {
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return d;
            }
            case 3: {
                return BigDecimal.valueOf(d);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(d);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "double", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, BigDecimal bigDecimal) throws SqlException {
        switch (n) {
            case -7: 
            case 16: {
                return BigDecimal.valueOf(0L).compareTo(bigDecimal) != 0;
            }
            case 5: {
                if (bigDecimal.compareTo(bdMaxShortValue__) == 1 || bigDecimal.compareTo(bdMinShortValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return bigDecimal.shortValue();
            }
            case 4: {
                if (bigDecimal.compareTo(bdMaxIntValue__) == 1 || bigDecimal.compareTo(bdMinIntValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return bigDecimal.intValue();
            }
            case -5: {
                if (bigDecimal.compareTo(bdMaxLongValue__) == 1 || bigDecimal.compareTo(bdMinLongValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return bigDecimal.longValue();
            }
            case 7: {
                if (bigDecimal.compareTo(bdMaxFloatValue__) == 1 || bigDecimal.compareTo(bdMinFloatValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf(bigDecimal.floatValue());
            }
            case 8: {
                if (bigDecimal.compareTo(bdMaxDoubleValue__) == 1 || bigDecimal.compareTo(bdMinDoubleValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return bigDecimal.doubleValue();
            }
            case 3: {
                return bigDecimal;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(bigDecimal);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.Math.BigDecimal", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, Date date) throws SqlException {
        switch (n) {
            case 91: {
                return date;
            }
            case 93: {
                return new Timestamp(date.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(date);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Date", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, Time time) throws SqlException {
        switch (n) {
            case 92: {
                return time;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(time);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Time", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, Timestamp timestamp) throws SqlException {
        switch (n) {
            case 93: {
                return timestamp;
            }
            case 92: {
                return new Time(timestamp.getTime());
            }
            case 91: {
                return new Date(timestamp.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(timestamp);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Timestamp", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, String string) throws SqlException {
        try {
            switch (n) {
                case -7: 
                case 16: {
                    String string2 = string.trim().toUpperCase(Locale.ENGLISH);
                    if (string2.equals("UNKNOWN")) {
                        return null;
                    }
                    if (string2.equals("TRUE")) {
                        return Boolean.TRUE;
                    }
                    if (string2.equals("FALSE")) {
                        return Boolean.FALSE;
                    }
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), ClientTypes.getTypeString(n));
                }
                case 5: {
                    return Short.valueOf(string);
                }
                case 4: {
                    return Integer.valueOf(string);
                }
                case -5: {
                    return Long.valueOf(string);
                }
                case 7: {
                    return Float.valueOf(string);
                }
                case 8: {
                    return Double.valueOf(string);
                }
                case 3: {
                    return new BigDecimal(string);
                }
                case 91: {
                    return CrossConverters.date_valueOf(string, null);
                }
                case 92: {
                    return CrossConverters.time_valueOf(string, null);
                }
                case 93: {
                    return CrossConverters.timestamp_valueOf(string, null);
                }
                case -1: 
                case 1: 
                case 12: {
                    return string;
                }
                case 2005: {
                    return new ClientClob(this.agent_, string);
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "String", ClientTypes.getTypeString(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, ClientTypes.getTypeString(n));
        }
    }

    public static int getInputJdbcType(int n) {
        switch (n) {
            case -6: 
            case 5: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 8;
            }
        }
        return n;
    }

    final Object setObject(int n, byte[] byArray) throws SqlException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return byArray;
            }
            case 2004: {
                return new ClientBlob(byArray, this.agent_, 0);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "byte[]", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, Reader reader, int n2) throws SqlException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromReader(reader, n2);
            }
            case 2005: {
                if (n2 == Integer.MIN_VALUE) {
                    return new ClientClob(this.agent_, reader);
                }
                return new ClientClob(this.agent_, reader, n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.Reader", ClientTypes.getTypeString(n));
    }

    private String setStringFromReader(Reader reader, int n) throws SqlException {
        StringWriter stringWriter = new StringWriter();
        try {
            int n2 = reader.read();
            int n3 = 0;
            while (n2 != -1) {
                ++n3;
                stringWriter.write(n2);
                n2 = reader.read();
            }
            if (n != Integer.MIN_VALUE && n != n3) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw SqlException.javaException(this.agent_.logWriter_, iOException);
        }
    }

    final Object setObjectFromCharacterStream(int n, InputStream inputStream2, Charset charset, int n2) throws SqlException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromStream(inputStream2, charset, n2);
            }
            case 2005: {
                if (n2 == Integer.MIN_VALUE) {
                    return new ClientClob(this.agent_, inputStream2, charset);
                }
                return new ClientClob(this.agent_, inputStream2, charset, n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.InputStream", ClientTypes.getTypeString(n));
    }

    private String setStringFromStream(InputStream inputStream2, Charset charset, int n) throws SqlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        try {
            int n3 = inputStream2.read();
            while (n3 != -1) {
                ++n2;
                byteArrayOutputStream.write(n3);
                n3 = inputStream2.read();
            }
        }
        catch (IOException iOException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), iOException, iOException.getClass().getName(), iOException.getMessage());
        }
        if (n != Integer.MIN_VALUE && n != n2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
        }
        return new String(byteArrayOutputStream.toByteArray(), charset);
    }

    final Object setObject(int n, Blob blob) throws SqlException {
        switch (n) {
            case 2004: {
                return blob;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Blob", ClientTypes.getTypeString(n));
    }

    final Object setObjectFromBinaryStream(int n, InputStream inputStream2, int n2) throws SqlException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return this.setBytesFromStream(inputStream2, n2);
            }
            case 2004: {
                if (n2 == Integer.MIN_VALUE) {
                    return new ClientBlob(this.agent_, inputStream2);
                }
                return new ClientBlob(this.agent_, inputStream2, n2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.InputStream", ClientTypes.getTypeString(n));
    }

    private byte[] setBytesFromStream(InputStream inputStream2, int n) throws SqlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        try {
            int n3 = inputStream2.read();
            while (n3 != -1) {
                ++n2;
                byteArrayOutputStream.write(n3);
                n3 = inputStream2.read();
            }
            if (n != Integer.MIN_VALUE && n != n2) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw SqlException.javaException(this.agent_.logWriter_, iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    final Object setObject(int n, Clob clob) throws SqlException {
        switch (n) {
            case 2005: {
                return clob;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Clob", ClientTypes.getTypeString(n));
    }

    final Object setObject(int n, Object object) throws SqlException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return this.setObject(n, (Boolean)object);
        }
        if (object instanceof Integer) {
            return this.setObject(n, (Integer)object);
        }
        if (object instanceof Long) {
            return this.setObject(n, (Long)object);
        }
        if (object instanceof Float) {
            return this.setObject(n, ((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.setObject(n, (Double)object);
        }
        if (object instanceof BigDecimal) {
            return this.setObject(n, (BigDecimal)object);
        }
        if (object instanceof Date) {
            return this.setObject(n, (Date)object);
        }
        if (object instanceof Time) {
            return this.setObject(n, (Time)object);
        }
        if (object instanceof Timestamp) {
            return this.setObject(n, (Timestamp)object);
        }
        if (object instanceof String) {
            return this.setObject(n, (String)object);
        }
        if (object instanceof byte[]) {
            return this.setObject(n, (byte[])object);
        }
        if (object instanceof Blob) {
            return this.setObject(n, (Blob)object);
        }
        if (object instanceof Clob) {
            return this.setObject(n, (Clob)object);
        }
        if (object instanceof Array) {
            return this.setObject(n, (Array)object);
        }
        if (object instanceof Ref) {
            return this.setObject(n, (Ref)object);
        }
        if (object instanceof Short) {
            return this.setObject(n, (Short)object);
        }
        if (object instanceof Byte) {
            return this.setObject(n, (Byte)object);
        }
        if (object instanceof BigInteger) {
            return this.setObject(n, new BigDecimal((BigInteger)object));
        }
        if (object instanceof java.util.Date) {
            return this.setObject(n, new Timestamp(((java.util.Date)object).getTime()));
        }
        if (object instanceof Calendar) {
            return this.setObject(n, new Timestamp(((Calendar)object).getTime().getTime()));
        }
        if (n == 2000) {
            return object;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), object.getClass().getName(), ClientTypes.getTypeString(n));
    }

    final boolean getBooleanFromShort(short s) throws SqlException {
        return s != 0;
    }

    final boolean getBooleanFromInt(int n) throws SqlException {
        return n != 0;
    }

    final boolean getBooleanFromLong(long l) throws SqlException {
        return l != 0L;
    }

    final boolean getBooleanFromFloat(float f) throws SqlException {
        return f != 0.0f;
    }

    final boolean getBooleanFromDouble(double d) throws SqlException {
        return d != 0.0;
    }

    final boolean getBooleanFromString(String string) {
        String string2 = string.trim();
        return !string2.equals("0") && !string2.equals("false");
    }

    final byte getByteFromShort(short s) throws SqlException {
        if (s > 127 || s < -128) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)s;
    }

    final byte getByteFromInt(int n) throws SqlException {
        if (n > 127 || n < -128) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)n;
    }

    final byte getByteFromLong(long l) throws SqlException {
        if (l > 127L || l < -128L) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)l;
    }

    final byte getByteFromFloat(float f) throws SqlException {
        if (f > 127.0f || f < -128.0f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)f;
    }

    final byte getByteFromDouble(double d) throws SqlException {
        if (d > 127.0 || d < -128.0) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)d;
    }

    final byte getByteFromBoolean(boolean bl) throws SqlException {
        return bl ? (byte)1 : 0;
    }

    final byte getByteFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "byte");
        }
    }

    final short getShortFromInt(int n) throws SqlException {
        if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)n;
    }

    final short getShortFromLong(long l) throws SqlException {
        if (l > 32767L || l < -32768L) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)l;
    }

    final short getShortFromFloat(float f) throws SqlException {
        if (f > 32767.0f || f < -32768.0f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)f;
    }

    final short getShortFromDouble(double d) throws SqlException {
        if (d > 32767.0 || d < -32768.0) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)d;
    }

    final short getShortFromBoolean(boolean bl) throws SqlException {
        return bl ? (short)1 : 0;
    }

    final short getShortFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "short");
        }
    }

    final int getIntFromLong(long l) throws SqlException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)l;
    }

    final int getIntFromFloat(float f) throws SqlException {
        if (f > 2.1474836E9f || f < -2.1474836E9f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)f;
    }

    final int getIntFromDouble(double d) throws SqlException {
        if (d > 2.147483647E9 || d < -2.147483648E9) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)d;
    }

    final int getIntFromBoolean(boolean bl) throws SqlException {
        return bl ? 1 : 0;
    }

    final int getIntFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "int");
        }
    }

    final long getLongFromFloat(float f) throws SqlException {
        if (f > 9.223372E18f || f < -9.223372E18f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
        }
        return (long)f;
    }

    final long getLongFromDouble(double d) throws SqlException {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
        }
        return (long)d;
    }

    final long getLongFromBoolean(boolean bl) throws SqlException {
        return bl ? 1L : 0L;
    }

    final long getLongFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "long");
        }
    }

    final float getFloatFromDouble(double d) throws SqlException {
        if (Float.isInfinite((float)d)) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
        }
        return (float)d;
    }

    final float getFloatFromBoolean(boolean bl) throws SqlException {
        return bl ? 1.0f : 0.0f;
    }

    final float getFloatFromString(String string) throws SqlException {
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "float");
        }
    }

    final double getDoubleFromBoolean(boolean bl) throws SqlException {
        return bl ? 1.0 : 0.0;
    }

    final double getDoubleFromString(String string) throws SqlException {
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "double");
        }
    }

    final BigDecimal getBigDecimalFromString(String string) throws SqlException {
        try {
            return new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "java.math.BigDecimal");
        }
    }

    final String getStringFromBytes(byte[] byArray) throws SqlException {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    final Date getDateFromString(String string, Calendar calendar) throws SqlException {
        try {
            return CrossConverters.date_valueOf(string, calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), illegalArgumentException, new Object[0]);
        }
    }

    final Time getTimeFromString(String string, Calendar calendar) throws SqlException {
        try {
            return CrossConverters.time_valueOf(string, calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), illegalArgumentException, new Object[0]);
        }
    }

    final Timestamp getTimestampFromString(String string, Calendar calendar) throws SqlException {
        try {
            return CrossConverters.timestamp_valueOf(string, calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), illegalArgumentException, new Object[0]);
        }
    }

    private static Date date_valueOf(String string, Calendar calendar) {
        String string2 = "JDBC Date format must be yyyy-mm-dd";
        if (string == null) {
            throw new IllegalArgumentException(string2);
        }
        string = string.trim();
        if (calendar == null) {
            return Date.valueOf(string);
        }
        calendar.clear();
        CrossConverters.initDatePortion(calendar, string);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    private static void initDatePortion(Calendar calendar, String string) {
        if (string.length() != 10 || string.charAt(4) != '-' || string.charAt(7) != '-') {
            throw new IllegalArgumentException();
        }
        int n = CrossConverters.digit(string.charAt(0)) * 1000 + CrossConverters.digit(string.charAt(1)) * 100 + CrossConverters.digit(string.charAt(2)) * 10 + CrossConverters.digit(string.charAt(3));
        int n2 = CrossConverters.digit(string.charAt(5)) * 10 + CrossConverters.digit(string.charAt(6)) - 1;
        int n3 = CrossConverters.digit(string.charAt(8)) * 10 + CrossConverters.digit(string.charAt(9));
        calendar.set(n, n2, n3);
    }

    private static int digit(char c) {
        int n = Character.digit(c, 10);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    private static Time time_valueOf(String string, Calendar calendar) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        if (calendar == null) {
            return Time.valueOf(string);
        }
        calendar.clear();
        CrossConverters.initTimePortion(calendar, string);
        calendar.set(1970, 0, 1);
        return new Time(calendar.getTimeInMillis());
    }

    private static void initTimePortion(Calendar calendar, String string) {
        if (string.length() != 8 || string.charAt(2) != ':' || string.charAt(5) != ':') {
            throw new IllegalArgumentException();
        }
        int n = CrossConverters.digit(string.charAt(0)) * 10 + CrossConverters.digit(string.charAt(1));
        int n2 = CrossConverters.digit(string.charAt(3)) * 10 + CrossConverters.digit(string.charAt(4));
        int n3 = CrossConverters.digit(string.charAt(6)) * 10 + CrossConverters.digit(string.charAt(7));
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
    }

    private static Timestamp timestamp_valueOf(String string, Calendar calendar) {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        if (calendar == null) {
            return Timestamp.valueOf(string);
        }
        calendar.clear();
        String[] stringArray = string.split(" ");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        CrossConverters.initDatePortion(calendar, string2);
        String[] stringArray2 = string3.split("\\.");
        if (stringArray2.length < 1 || stringArray2.length > 2) {
            throw new IllegalArgumentException();
        }
        String string4 = stringArray2[0];
        CrossConverters.initTimePortion(calendar, string4);
        int n = 0;
        if (stringArray2.length > 1) {
            object = stringArray2[1];
            int n2 = 9 - ((String)object).length();
            if (n2 < 0) {
                throw new IllegalArgumentException();
            }
            n = Integer.parseInt((String)object);
            for (int i = 0; i < n2; ++i) {
                n *= 10;
            }
        }
        object = new Timestamp(calendar.getTimeInMillis());
        ((Timestamp)object).setNanos(n);
        return object;
    }

    private static byte parseByte(String string) throws NumberFormatException {
        int n = CrossConverters.parseInt(string);
        if (n < -128 || n > 127) {
            throw new NumberFormatException();
        }
        return (byte)n;
    }

    private static short parseShort(String string) throws NumberFormatException {
        int n = CrossConverters.parseInt(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)n;
    }

    private static int parseInt(String string) throws NumberFormatException {
        int n;
        int n2;
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = string.length();
        if (n5 == 0) {
            throw new NumberFormatException(string);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            n2 = Integer.MIN_VALUE;
            ++n4;
        } else {
            n2 = -2147483647;
        }
        int n6 = n2 / 10;
        if (n4 < n5) {
            if ((n = Character.digit(string.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException(string);
            }
            n3 = -n;
        }
        while (n4 < n5) {
            char c;
            if ((c = string.charAt(n4++)) == ' ') {
                CrossConverters.skipPadding(string, n4, n5);
                break;
            }
            n = Character.digit(c, 10);
            if (n < 0) {
                throw new NumberFormatException(string);
            }
            if (n3 < n6) {
                throw new NumberFormatException(string);
            }
            if ((n3 *= 10) < n2 + n) {
                throw new NumberFormatException(string);
            }
            n3 -= n;
        }
        if (bl) {
            if (n4 > 1) {
                return n3;
            }
            throw new NumberFormatException(string);
        }
        return -n3;
    }

    private static long parseLong(String string) throws NumberFormatException {
        int n;
        long l;
        if (string == null) {
            throw new NumberFormatException("null");
        }
        long l2 = 0L;
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new NumberFormatException(string);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n2;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = l / 10L;
        if (n2 < n3) {
            if ((n = Character.digit(string.charAt(n2++), 10)) < 0) {
                throw new NumberFormatException(string);
            }
            l2 = -n;
        }
        while (n2 < n3) {
            char c;
            if ((c = string.charAt(n2++)) == ' ') {
                CrossConverters.skipPadding(string, n2, n3);
                break;
            }
            n = Character.digit(c, 10);
            if (n < 0) {
                throw new NumberFormatException(string);
            }
            if (l2 < l3) {
                throw new NumberFormatException(string);
            }
            if ((l2 *= 10L) < l + (long)n) {
                throw new NumberFormatException(string);
            }
            l2 -= (long)n;
        }
        if (bl) {
            if (n2 > 1) {
                return l2;
            }
            throw new NumberFormatException(string);
        }
        return -l2;
    }

    private static void skipPadding(String string, int n, int n2) throws NumberFormatException {
        while (n < n2) {
            if (string.charAt(n++) == ' ') continue;
            throw new NumberFormatException(string);
        }
    }
}

