/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.InputStream;
import org.apache.derby.iapi.types.PositionedStream;

public class CharacterStreamDescriptor {
    public static final long BEFORE_FIRST = 0L;
    private final long dataOffset;
    private final long curBytePos;
    private final long curCharPos;
    private final long byteLength;
    private final long charLength;
    private final long maxCharLength;
    private final boolean bufferable;
    private final boolean positionAware;
    private final InputStream stream;

    private CharacterStreamDescriptor(Builder builder) {
        this.bufferable = builder.bufferable;
        this.positionAware = builder.positionAware;
        this.dataOffset = builder.dataOffset;
        this.curBytePos = builder.curBytePos;
        this.curCharPos = builder.curCharPos;
        this.byteLength = builder.byteLength;
        this.charLength = builder.charLength;
        this.maxCharLength = builder.maxCharLength;
        this.stream = builder.stream;
    }

    public boolean isBufferable() {
        return this.bufferable;
    }

    public boolean isPositionAware() {
        return this.positionAware;
    }

    public long getByteLength() {
        return this.byteLength;
    }

    public long getCharLength() {
        return this.charLength;
    }

    public long getCurBytePos() {
        return this.curBytePos;
    }

    public long getCurCharPos() {
        return this.curCharPos;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public long getMaxCharLength() {
        return this.maxCharLength;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public PositionedStream getPositionedStream() {
        if (!this.positionAware) {
            throw new IllegalStateException("stream is not position aware: " + this.stream.getClass().getName());
        }
        return (PositionedStream)((Object)this.stream);
    }

    public String toString() {
        return "CharacterStreamDescriptor-" + this.hashCode() + "#bufferable=" + this.bufferable + ":positionAware=" + this.positionAware + ":byteLength=" + this.byteLength + ":charLength=" + this.charLength + ":curBytePos=" + this.curBytePos + ":curCharPos=" + this.curCharPos + ":dataOffset=" + this.dataOffset + ":stream=" + this.stream.getClass();
    }

    public static class Builder {
        private static final long DEFAULT_MAX_CHAR_LENGTH = Long.MAX_VALUE;
        private boolean bufferable = false;
        private boolean positionAware = false;
        private long curBytePos = 0L;
        private long curCharPos = 1L;
        private long byteLength = 0L;
        private long charLength = 0L;
        private long dataOffset = 0L;
        private long maxCharLength = Long.MAX_VALUE;
        private InputStream stream;

        public Builder bufferable(boolean bl) {
            this.bufferable = bl;
            return this;
        }

        public Builder positionAware(boolean bl) {
            this.positionAware = bl;
            return this;
        }

        public Builder curBytePos(long l) {
            this.curBytePos = l;
            return this;
        }

        public Builder curCharPos(long l) {
            this.curCharPos = l;
            return this;
        }

        public Builder byteLength(long l) {
            this.byteLength = l;
            return this;
        }

        public Builder copyState(CharacterStreamDescriptor characterStreamDescriptor) {
            this.bufferable = characterStreamDescriptor.bufferable;
            this.byteLength = characterStreamDescriptor.byteLength;
            this.charLength = characterStreamDescriptor.charLength;
            this.curBytePos = characterStreamDescriptor.curBytePos;
            this.curCharPos = characterStreamDescriptor.curCharPos;
            this.dataOffset = characterStreamDescriptor.dataOffset;
            this.maxCharLength = characterStreamDescriptor.maxCharLength;
            this.positionAware = characterStreamDescriptor.positionAware;
            this.stream = characterStreamDescriptor.stream;
            return this;
        }

        public Builder charLength(long l) {
            this.charLength = l;
            return this;
        }

        public Builder dataOffset(long l) {
            this.dataOffset = l;
            return this;
        }

        public Builder maxCharLength(long l) {
            this.maxCharLength = l;
            return this;
        }

        public Builder stream(InputStream inputStream2) {
            this.stream = inputStream2;
            return this;
        }

        public CharacterStreamDescriptor build() {
            return new CharacterStreamDescriptor(this);
        }

        public String toString() {
            String string = "CharacterStreamBuiler@" + this.hashCode() + ":bufferable=" + this.bufferable + ", isPositionAware=" + this.positionAware + ", curBytePos=" + this.curBytePos + ", curCharPos=" + this.curCharPos + ", dataOffset=" + this.dataOffset + ", byteLength=" + this.byteLength + ", charLength=" + this.charLength + ", maxCharLength=" + this.maxCharLength + ", stream=" + this.stream.getClass();
            return string;
        }
    }
}

