/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public abstract class CompressedNumber {
    public static final int MAX_INT_STORED_SIZE = 4;
    public static final int MAX_LONG_STORED_SIZE = 8;
    public static final int MAX_COMPRESSED_INT_ONE_BYTE = 63;
    public static final int MAX_COMPRESSED_INT_TWO_BYTES = 16383;

    public static final int writeInt(DataOutput dataOutput, int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        if (n <= 63) {
            dataOutput.writeByte(n);
            return 1;
        }
        if (n <= 16383) {
            dataOutput.writeByte(0x40 | n >>> 8);
            dataOutput.writeByte(n & 0xFF);
            return 2;
        }
        dataOutput.writeByte((n >>> 24 | 0x80) & 0xFF);
        dataOutput.writeByte(n >>> 16 & 0xFF);
        dataOutput.writeByte(n >>> 8 & 0xFF);
        dataOutput.writeByte(n & 0xFF);
        return 4;
    }

    public static final int writeInt(OutputStream outputStream2, int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        if (n <= 63) {
            outputStream2.write(n);
            return 1;
        }
        if (n <= 16383) {
            outputStream2.write(0x40 | n >>> 8);
            outputStream2.write(n & 0xFF);
            return 2;
        }
        outputStream2.write((n >>> 24 | 0x80) & 0xFF);
        outputStream2.write(n >>> 16 & 0xFF);
        outputStream2.write(n >>> 8 & 0xFF);
        outputStream2.write(n & 0xFF);
        return 4;
    }

    public static final int readInt(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if ((n & 0xFFFFFFC0) == 0) {
            return n;
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 8 | dataInput.readUnsignedByte();
        }
        return (n & 0x7F) << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
    }

    public static final int readInt(InputStream inputStream2) throws IOException {
        int n = InputStreamUtil.readUnsignedByte(inputStream2);
        if ((n & 0xFFFFFFC0) == 0) {
            return n;
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 8 | InputStreamUtil.readUnsignedByte(inputStream2);
        }
        return (n & 0x7F) << 24 | InputStreamUtil.readUnsignedByte(inputStream2) << 16 | InputStreamUtil.readUnsignedByte(inputStream2) << 8 | InputStreamUtil.readUnsignedByte(inputStream2);
    }

    public static final int readInt(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            return by;
        }
        if ((by & 0x80) == 0) {
            return (by & 0x3F) << 8 | byArray[n] & 0xFF;
        }
        return (by & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static final int sizeInt(int n) {
        if (n <= 63) {
            return 1;
        }
        if (n <= 16383) {
            return 2;
        }
        return 4;
    }

    public static final int writeLong(DataOutput dataOutput, long l) throws IOException {
        if (l < 0L) {
            throw new IOException();
        }
        if (l <= 16383L) {
            dataOutput.writeByte((int)(l >>> 8 & 0xFFL));
            dataOutput.writeByte((int)(l & 0xFFL));
            return 2;
        }
        if (l <= 0x3FFFFFFFL) {
            dataOutput.writeByte((int)((l >>> 24 | 0x40L) & 0xFFL));
            dataOutput.writeByte((int)(l >>> 16 & 0xFFL));
            dataOutput.writeByte((int)(l >>> 8 & 0xFFL));
            dataOutput.writeByte((int)(l & 0xFFL));
            return 4;
        }
        dataOutput.writeByte((int)((l >>> 56 | 0x80L) & 0xFFL));
        dataOutput.writeByte((int)(l >>> 48 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 40 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 32 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 24 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 16 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 8 & 0xFFL));
        dataOutput.writeByte((int)(l & 0xFFL));
        return 8;
    }

    public static final int writeLong(OutputStream outputStream2, long l) throws IOException {
        if (l < 0L) {
            throw new IOException();
        }
        if (l <= 16383L) {
            outputStream2.write((int)(l >>> 8 & 0xFFL));
            outputStream2.write((int)(l & 0xFFL));
            return 2;
        }
        if (l <= 0x3FFFFFFFL) {
            outputStream2.write((int)((l >>> 24 | 0x40L) & 0xFFL));
            outputStream2.write((int)(l >>> 16 & 0xFFL));
            outputStream2.write((int)(l >>> 8 & 0xFFL));
            outputStream2.write((int)(l & 0xFFL));
            return 4;
        }
        outputStream2.write((int)((l >>> 56 | 0x80L) & 0xFFL));
        outputStream2.write((int)(l >>> 48 & 0xFFL));
        outputStream2.write((int)(l >>> 40 & 0xFFL));
        outputStream2.write((int)(l >>> 32 & 0xFFL));
        outputStream2.write((int)(l >>> 24 & 0xFFL));
        outputStream2.write((int)(l >>> 16 & 0xFFL));
        outputStream2.write((int)(l >>> 8 & 0xFFL));
        outputStream2.write((int)(l & 0xFFL));
        return 8;
    }

    public static final long readLong(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if ((n & 0xFFFFFFC0) == 0) {
            return n << 8 | dataInput.readUnsignedByte();
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        return (long)(n & 0x7F) << 56 | (long)dataInput.readUnsignedByte() << 48 | (long)dataInput.readUnsignedByte() << 40 | (long)dataInput.readUnsignedByte() << 32 | (long)dataInput.readUnsignedByte() << 24 | (long)dataInput.readUnsignedByte() << 16 | (long)dataInput.readUnsignedByte() << 8 | (long)dataInput.readUnsignedByte();
    }

    public static final long readLong(InputStream inputStream2) throws IOException {
        int n = InputStreamUtil.readUnsignedByte(inputStream2);
        if ((n & 0xFFFFFFC0) == 0) {
            return n << 8 | InputStreamUtil.readUnsignedByte(inputStream2);
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 24 | InputStreamUtil.readUnsignedByte(inputStream2) << 16 | InputStreamUtil.readUnsignedByte(inputStream2) << 8 | InputStreamUtil.readUnsignedByte(inputStream2);
        }
        long l = n;
        return (l & 0x7FL) << 56 | (long)InputStreamUtil.readUnsignedByte(inputStream2) << 48 | (long)InputStreamUtil.readUnsignedByte(inputStream2) << 40 | (long)InputStreamUtil.readUnsignedByte(inputStream2) << 32 | (long)InputStreamUtil.readUnsignedByte(inputStream2) << 24 | (long)InputStreamUtil.readUnsignedByte(inputStream2) << 16 | (long)InputStreamUtil.readUnsignedByte(inputStream2) << 8 | (long)InputStreamUtil.readUnsignedByte(inputStream2);
    }

    public static final long readLong(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            return by << 8 | byArray[n] & 0xFF;
        }
        if ((by & 0x80) == 0) {
            return (by & 0x3F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        return (long)(by & 0x7F) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n] & 0xFF);
    }

    public static final int sizeLong(long l) {
        if (l <= 16383L) {
            return 2;
        }
        if (l <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }
}

