/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.Limit;

public class CounterOutputStream
extends OutputStream
implements Limit {
    protected OutputStream out;
    private int count;
    private int limit = -1;

    public void setOutputStream(OutputStream outputStream2) {
        this.out = outputStream2;
        this.setLimit(-1);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void setLimit(int n) {
        this.count = 0;
        this.limit = n;
    }

    @Override
    public int clearLimit() {
        int n = this.limit - this.count;
        this.limit = 0;
        return n;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.limit >= 0 && this.count + 1 > this.limit) {
            throw new EOFException();
        }
        if (this.out != null) {
            this.out.write(n);
        }
        ++this.count;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.limit >= 0 && this.count + n2 > this.limit) {
            throw new EOFException();
        }
        if (this.out != null) {
            this.out.write(byArray, n, n2);
        }
        this.count += n2;
    }
}

