/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.Limit;

public class LimitInputStream
extends FilterInputStream
implements Limit {
    protected int remainingBytes;
    protected boolean limitInPlace;

    public LimitInputStream(InputStream inputStream2) {
        super(inputStream2);
        this.clearLimit();
    }

    @Override
    public int read() throws IOException {
        if (!this.limitInPlace) {
            return super.read();
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        int n = super.read();
        if (n >= 0) {
            --this.remainingBytes;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.limitInPlace) {
            return super.read(byArray, n, n2);
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        if (this.remainingBytes < n2) {
            n2 = this.remainingBytes;
        }
        if ((n2 = super.read(byArray, n, n2)) > 0) {
            this.remainingBytes -= n2;
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        if (!this.limitInPlace) {
            return super.skip(l);
        }
        if (this.remainingBytes == 0) {
            return 0L;
        }
        if ((long)this.remainingBytes < l) {
            l = this.remainingBytes;
        }
        l = super.skip(l);
        this.remainingBytes = (int)((long)this.remainingBytes - l);
        return l;
    }

    @Override
    public int available() throws IOException {
        if (!this.limitInPlace) {
            return super.available();
        }
        if (this.remainingBytes == 0) {
            return 0;
        }
        int n = super.available();
        if (this.remainingBytes < n) {
            return this.remainingBytes;
        }
        return n;
    }

    @Override
    public void setLimit(int n) {
        this.remainingBytes = n;
        this.limitInPlace = true;
    }

    @Override
    public int clearLimit() {
        int n = this.remainingBytes;
        this.limitInPlace = false;
        this.remainingBytes = -1;
        return n;
    }

    public void setInput(InputStream inputStream2) {
        this.in = inputStream2;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

