/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.transaction.TransactionListener;

public final class TransactionControl {
    public static final int UNSPECIFIED_ISOLATION_LEVEL = 0;
    public static final int READ_UNCOMMITTED_ISOLATION_LEVEL = 1;
    public static final int READ_COMMITTED_ISOLATION_LEVEL = 2;
    public static final int REPEATABLE_READ_ISOLATION_LEVEL = 3;
    public static final int SERIALIZABLE_ISOLATION_LEVEL = 4;
    private static final int[] CS_TO_JDBC_ISOLATION_LEVEL_MAP = new int[]{0, 1, 2, 4, 8};
    private static final String[][] CS_TO_SQL_ISOLATION_MAP = new String[][]{{"  "}, {"UR", "DIRTY READ", "READ UNCOMMITTED"}, {"CS", "CURSOR STABILITY", "READ COMMITTED"}, {"RS"}, {"RR", "REPEATABLE READ", "SERIALIZABLE"}};
    private final ArrayList<TransactionListener> listeners = new ArrayList();

    public static int jdbcIsolationLevel(int n) {
        return CS_TO_JDBC_ISOLATION_LEVEL_MAP[n];
    }

    public static String[] isolationTextNames(int n) {
        return ArrayUtil.copy(CS_TO_SQL_ISOLATION_MAP[n]);
    }

    public static int isolationMapCount() {
        return CS_TO_SQL_ISOLATION_MAP.length;
    }

    public void addListener(TransactionListener transactionListener) {
        this.listeners.add(transactionListener);
    }

    public void removeListener(TransactionListener transactionListener) {
        this.listeners.remove(transactionListener);
    }

    public void preCommitNotify() throws StandardException {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator<TransactionListener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            TransactionListener transactionListener = iterator2.next();
            try {
                if (!transactionListener.preCommit()) continue;
                iterator2.remove();
            }
            catch (StandardException standardException) {
                if (standardException.getSeverity() < 30000) {
                    throw StandardException.newException("40XT1", standardException, new Object[0]);
                }
                throw standardException;
            }
        }
    }

    public void preRollbackNotify() throws StandardException {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator<TransactionListener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            TransactionListener transactionListener = iterator2.next();
            try {
                transactionListener.preRollback();
                iterator2.remove();
            }
            catch (StandardException standardException) {
                if (standardException.getSeverity() < 30000) {
                    // empty if block
                }
                throw standardException;
            }
        }
    }
}

