/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public final class UTF8Util {
    private UTF8Util() {
    }

    public static final long skipUntilEOF(InputStream inputStream2) throws IOException {
        return UTF8Util.internalSkip(inputStream2, Long.MAX_VALUE).charsSkipped();
    }

    public static final long skipFully(InputStream inputStream2, long l) throws EOFException, IOException {
        SkipCount skipCount = UTF8Util.internalSkip(inputStream2, l);
        if (skipCount.charsSkipped() != l) {
            throw new EOFException("Reached end-of-stream prematurely at character/byte position " + skipCount.charsSkipped() + "/" + skipCount.bytesSkipped() + ", trying to skip " + l);
        }
        return skipCount.bytesSkipped();
    }

    private static final SkipCount internalSkip(InputStream inputStream2, long l) throws IOException {
        int n;
        long l2 = 0L;
        long l3 = 0L;
        while (l2 < l && (n = inputStream2.read()) != -1) {
            ++l2;
            if ((n & 0x80) == 0) {
                ++l3;
                continue;
            }
            if ((n & 0x60) == 64) {
                if (InputStreamUtil.skipPersistent(inputStream2, 1L) != 1L) {
                    throw new UTFDataFormatException("Second byte in two byte character missing; byte pos " + l3 + " ; char pos " + l2);
                }
                l3 += 2L;
                continue;
            }
            if ((n & 0x70) == 96) {
                int n2 = 0;
                if (n == 224) {
                    int n3 = inputStream2.read();
                    int n4 = inputStream2.read();
                    if (n3 == 0 && n4 == 0) {
                        --l2;
                        break;
                    }
                    if (n3 != -1 && n4 != -1) {
                        n2 = 2;
                    }
                } else {
                    n2 = (int)InputStreamUtil.skipPersistent(inputStream2, 2L);
                }
                if (n2 != 2) {
                    throw new UTFDataFormatException("Second or third byte in three byte character missing; byte pos " + l3 + " ; char pos " + l2);
                }
                l3 += 3L;
                continue;
            }
            throw new UTFDataFormatException("Invalid UTF-8 encoding encountered: (decimal) " + n);
        }
        return new SkipCount(l2, l3);
    }

    private static final class SkipCount {
        private final long byteCount;
        private final long charCount;

        SkipCount(long l, long l2) {
            if (l2 < 0L || l < 0L) {
                throw new IllegalArgumentException("charCount/byteCount cannot be negative: " + l + "/" + l2);
            }
            if (l2 < l) {
                throw new IllegalArgumentException("Number of bytes cannot beless than number of chars: " + l2 + " < " + l);
            }
            this.byteCount = l2;
            this.charCount = l;
        }

        long charsSkipped() {
            return this.charCount;
        }

        long bytesSkipped() {
            return this.byteCount;
        }
    }
}

