/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class BinaryToRawStream
extends FilterInputStream {
    private int length;
    private Object parent;

    BinaryToRawStream(InputStream inputStream2, Object object) throws IOException {
        super(inputStream2);
        this.parent = object;
        int n = inputStream2.read();
        if (n == -1) {
            throw new EOFException();
        }
        if ((n & 0x80) != 0) {
            if (n == 192) {
                int n2 = inputStream2.read();
                int n3 = inputStream2.read();
                int n4 = inputStream2.read();
                int n5 = inputStream2.read();
                if (n2 == -1 || n3 == -1 || n4 == -1 || n5 == -1) {
                    throw new EOFException();
                }
                this.length = (n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n5 & 0xFF;
            } else if (n == 160) {
                int n6 = inputStream2.read();
                int n7 = inputStream2.read();
                if (n6 == -1 || n7 == -1) {
                    throw new EOFException();
                }
                this.length = ((n6 & 0xFF) << 8) + (n7 & 0xFF);
            } else {
                this.length = n & 0x1F;
            }
        } else {
            int n8 = inputStream2.read();
            int n9 = inputStream2.read();
            int n10 = inputStream2.read();
            if (n8 == -1 || n9 == -1 || n10 == -1) {
                throw new EOFException();
            }
            int n11 = (n & 0xFF) << 24 | (n8 & 0xFF) << 16 | (n9 & 0xFF) << 8 | n10 & 0xFF;
            this.length = n11 / 8;
            if (n11 % 8 != 0) {
                ++this.length;
            }
            if (this.length == 0) {
                this.length = -1;
            }
        }
    }

    int getLength() {
        return this.length;
    }
}

