/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.jdbc.FailedProperties40;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.memory.LowMemory;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.db.SlaveDatabase;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnectionContext;
import org.apache.derby.impl.jdbc.EmbedSavepoint;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import org.apache.derby.jdbc.InternalDriver;
import org.apache.derby.security.DatabasePermission;

public class EmbedConnection
implements EngineConnection {
    protected static final StandardException exceptionClose = StandardException.closeException();
    public static final SQLException NO_MEM = EmbedConnection.newSQLException("08004", "java.lang.OutOfMemoryError");
    public static final LowMemory memoryState = new LowMemory();
    DatabaseMetaData dbMetadata;
    TransactionResourceImpl tr;
    private HashMap<Integer, Object> lobHashMap = null;
    private int lobHMKey = 0;
    private WeakHashMap<Object, Object> lobReferences = null;
    private HashSet<LOBFile> lobFiles;
    private boolean active;
    private boolean aborting = false;
    boolean autoCommit = true;
    boolean needCommit;
    private boolean usingNoneAuth;
    private int connectionHoldAbility = 1;
    final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    private InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String connString;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_SHUTDOWN = 1;
    private static final int OP_HARD_UPGRADE = 2;
    private static final int OP_REPLICATION = 3;
    private static final int OP_DECRYPT = 4;

    public EmbedConnection(InternalDriver internalDriver, String string, Properties properties) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = internalDriver;
        this.tr = new TransactionResourceImpl(internalDriver, string, properties);
        this.active = true;
        this.setupContextStack();
        try {
            String string2;
            boolean bl;
            EmbedConnectionContext embedConnectionContext = this.pushConnectionContext(this.tr.getContextManager());
            boolean bl2 = EmbedConnection.isTrue(properties, "shutdown");
            Database database = (Database)EmbedConnection.findService("org.apache.derby.database.Database", this.tr.getDBName());
            if (database != null && this.isCryptoBoot(properties)) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J17", new Object[0]));
            }
            boolean bl3 = !(bl = this.createBoot(properties)) && this.isCryptoBoot(properties);
            boolean bl4 = !bl && this.isHardUpgradeBoot(properties);
            boolean bl5 = this.isStartReplicationSlaveBoot(properties);
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = this.isDropDatabase(properties);
            if (bl2 && bl9) {
                throw EmbedConnection.newSQLException("XJ048.C", "shutdown, drop");
            }
            if (bl3) {
                this.checkConflictingCryptoAttributes(properties);
            }
            if ((string2 = this.getReplicationOperation(properties)) != null && (bl || bl2 || bl9 || bl3 || bl4)) {
                throw StandardException.newException("XRE10", string2);
            }
            if (this.isReplicationFailover(properties)) {
                this.checkDatabaseBooted(database, "failover", this.tr.getDBName());
                if (database.isInSlaveMode()) {
                    bl8 = true;
                } else {
                    bl7 = true;
                }
            }
            Properties properties2 = null;
            if (bl5) {
                if (database != null) {
                    bl6 = true;
                } else {
                    properties.setProperty("replication.slave.mode", "slavepremode");
                }
            }
            if (this.isStopReplicationSlaveBoot(properties)) {
                this.handleStopReplicationSlave(database, properties);
            } else {
                if (this.isInternalShutdownSlaveDatabase(properties)) {
                    this.internalStopReplicationSlave(database, properties);
                    return;
                }
                if (bl8) {
                    this.handleFailoverSlave(database);
                }
            }
            if (database != null) {
                this.tr.setDatabase(database);
                bl3 = false;
                bl4 = false;
            } else if (!bl2) {
                if (bl3 || bl4) {
                    properties2 = properties;
                    properties = this.removePhaseTwoProps((Properties)properties.clone());
                }
                if (!this.bootDatabase(properties, bl4)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
            }
            if (bl && !bl2 && !bl9) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(SQLWarningFactory.newSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(true, null, properties);
                    database = this.createDatabase(this.tr.getDBName(), properties);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                this.handleDBNotFound();
            }
            try {
                this.checkUserCredentials(false, this.tr.getDBName(), properties);
            }
            catch (SQLException sQLException) {
                if (bl5 && !bl6) {
                    this.tr.startTransaction();
                    this.handleException(this.tr.shutdownDatabaseException());
                }
                throw sQLException;
            }
            this.tr.startTransaction();
            if (this.isStartReplicationMasterBoot(properties) || this.isStopReplicationMasterBoot(properties) || bl7) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    this.checkIsDBOwner(3);
                }
                if (this.isStartReplicationMasterBoot(properties)) {
                    this.handleStartReplicationMaster(this.tr, properties);
                } else if (this.isStopReplicationMasterBoot(properties)) {
                    this.handleStopReplicationMaster(this.tr, properties);
                } else if (bl7) {
                    this.handleFailoverMaster(this.tr);
                }
            }
            if (bl3 || bl4 || bl5) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    int n = bl3 ? (EmbedConnection.isTrue(properties2, "decryptDatabase") ? 4 : 0) : (bl4 ? 2 : 3);
                    try {
                        this.checkIsDBOwner(n);
                    }
                    catch (SQLException sQLException) {
                        if (bl5) {
                            this.handleException(this.tr.shutdownDatabaseException());
                        }
                        throw sQLException;
                    }
                }
                if (bl5) {
                    if (bl6) {
                        throw StandardException.newException("XRE09.C", this.getTR().getDBName());
                    }
                    properties.setProperty("replication.slave.mode", "slavemode");
                    properties.setProperty("replication.slave.dbname", this.getTR().getDBName());
                } else {
                    properties = properties2;
                }
                this.handleException(this.tr.shutdownDatabaseException());
                this.restoreContextStack();
                this.tr = new TransactionResourceImpl(internalDriver, string, properties);
                this.active = true;
                this.setupContextStack();
                embedConnectionContext = this.pushConnectionContext(this.tr.getContextManager());
                if (!this.bootDatabase(properties, false)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
                if (bl5) {
                    throw StandardException.newException("XRE08", this.getTR().getDBName());
                }
                this.tr.startTransaction();
            }
            if (bl2) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                throw this.tr.shutdownDatabaseException();
            }
            if (bl9) {
                if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                String string3 = this.tr.getDBName();
                this.handleException(this.tr.shutdownDatabaseException());
                EmbedConnection.sleep(500L);
                EmbedConnection.removePersistentService(string3);
                StandardException standardException = StandardException.newException("08006.D.1", string3);
                standardException.setReport(1);
                throw standardException;
            }
            if (this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J14", new Object[0]));
            }
            InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InterruptStatus.restoreIntrFlagIfSeen();
            this.restoreContextStack();
            this.tr.lcc = null;
            this.tr.cm = null;
            memoryState.setLowMemory();
            throw NO_MEM;
        }
        catch (Throwable throwable) {
            StandardException standardException;
            InterruptStatus.restoreIntrFlagIfSeen();
            if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getSeverity() < 40000) {
                standardException.setSeverity(40000);
            }
            this.tr.cleanupOnError(throwable, false);
            throw this.handleException(throwable);
        }
        finally {
            this.restoreContextStack();
        }
    }

    private void checkDatabaseBooted(Database database, String string, String string2) throws SQLException {
        if (database == null) {
            this.setInactive();
            throw EmbedConnection.newSQLException("XRE11.C", string, string2);
        }
    }

    private boolean createBoot(Properties properties) throws SQLException {
        int n = 0;
        if (EmbedConnection.isTrue(properties, "create")) {
            ++n;
        }
        int n2 = 0;
        if (EmbedConnection.isSet(properties, "createFrom")) {
            ++n2;
        }
        if (EmbedConnection.isSet(properties, "restoreFrom")) {
            ++n2;
        }
        if (EmbedConnection.isSet(properties, "rollForwardRecoveryFrom")) {
            ++n2;
        }
        if (n2 > 1) {
            throw EmbedConnection.newSQLException("XJ081.C", new Object[0]);
        }
        if (n2 != 0 && this.isCryptoBoot(properties)) {
            throw EmbedConnection.newSQLException("XJ081.C", new Object[0]);
        }
        if ((n += n2) > 1) {
            throw EmbedConnection.newSQLException("XJ049.C", new Object[0]);
        }
        if (n == 1 && this.isDropDatabase(properties)) {
            String string = "XJ049.C";
            if (n2 > 0) {
                string = "XJ081.C";
            }
            throw EmbedConnection.newSQLException(string, new Object[0]);
        }
        return n - n2 == 1;
    }

    private void handleDBNotFound() throws SQLException {
        String string = this.tr.getDBName();
        this.setInactive();
        throw EmbedConnection.newSQLException("XJ004.C", string);
    }

    private boolean isDropDatabase(Properties properties) {
        return EmbedConnection.isTrue(properties, "drop");
    }

    private boolean isCryptoBoot(Properties properties) throws SQLException {
        return EmbedConnection.vetTrue(properties, "dataEncryption") || EmbedConnection.vetTrue(properties, "decryptDatabase") || EmbedConnection.isSet(properties, "newBootPassword") || EmbedConnection.isSet(properties, "newEncryptionKey");
    }

    private boolean isHardUpgradeBoot(Properties properties) {
        return EmbedConnection.isTrue(properties, "upgrade");
    }

    private boolean isStartReplicationSlaveBoot(Properties properties) {
        return EmbedConnection.isTrue(properties, "startSlave");
    }

    private boolean isStartReplicationMasterBoot(Properties properties) {
        return EmbedConnection.isTrue(properties, "startMaster");
    }

    private boolean isReplicationFailover(Properties properties) {
        return EmbedConnection.isTrue(properties, "failover");
    }

    private boolean isStopReplicationMasterBoot(Properties properties) {
        return EmbedConnection.isTrue(properties, "stopMaster");
    }

    private boolean isStopReplicationSlaveBoot(Properties properties) {
        return EmbedConnection.isTrue(properties, "stopSlave");
    }

    private boolean isInternalShutdownSlaveDatabase(Properties properties) {
        return EmbedConnection.isTrue(properties, "internal_stopslave");
    }

    private static boolean isSet(Properties properties, String string) {
        return properties.getProperty(string) != null;
    }

    private static boolean isTrue(Properties properties, String string) {
        return Boolean.valueOf(properties.getProperty(string));
    }

    private static boolean vetTrue(Properties properties, String string) throws SQLException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        if (Boolean.valueOf(string2).booleanValue()) {
            return true;
        }
        throw EmbedConnection.newSQLException("XJ05B.C", string, string2, Boolean.TRUE.toString());
    }

    private String getReplicationOperation(Properties properties) throws StandardException {
        String string = null;
        int n = 0;
        if (this.isStartReplicationSlaveBoot(properties)) {
            string = "startSlave";
            ++n;
        }
        if (this.isStartReplicationMasterBoot(properties)) {
            string = "startMaster";
            ++n;
        }
        if (this.isStopReplicationSlaveBoot(properties)) {
            string = "stopSlave";
            ++n;
        }
        if (this.isInternalShutdownSlaveDatabase(properties)) {
            string = "internal_stopslave";
            ++n;
        }
        if (this.isStopReplicationMasterBoot(properties)) {
            string = "stopMaster";
            ++n;
        }
        if (this.isReplicationFailover(properties)) {
            string = "failover";
            ++n;
        }
        if (n > 1) {
            throw StandardException.newException("XRE10", string);
        }
        return string;
    }

    private void handleStartReplicationMaster(TransactionResourceImpl transactionResourceImpl, Properties properties) throws SQLException {
        String string;
        if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        if ((string = properties.getProperty("slaveHost")) == null) {
            SQLException sQLException = EmbedConnection.newSQLException("XCY03.S", "slaveHost");
            throw EmbedConnection.newSQLException("08004", sQLException);
        }
        String string2 = properties.getProperty("slavePort");
        int n = -1;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        transactionResourceImpl.getDatabase().startReplicationMaster(this.getTR().getDBName(), string, n, "derby.__rt.asynch");
    }

    private void handleStopReplicationMaster(TransactionResourceImpl transactionResourceImpl, Properties properties) throws SQLException {
        if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        transactionResourceImpl.getDatabase().stopReplicationMaster();
    }

    private void handleStopReplicationSlave(Database database, Properties properties) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "stopSlave", this.tr.getDBName());
        database.stopReplicationSlave();
        throw EmbedConnection.newSQLException("XRE42.C", this.getTR().getDBName());
    }

    private void internalStopReplicationSlave(Database database, Properties properties) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "internal_stopslave", this.tr.getDBName());
        if (!(database instanceof SlaveDatabase)) {
            throw EmbedConnection.newSQLException("XRE40", new Object[0]);
        }
        ((SlaveDatabase)database).verifyShutdownSlave();
        this.handleException(this.tr.shutdownDatabaseException());
    }

    private void handleFailoverMaster(TransactionResourceImpl transactionResourceImpl) throws SQLException, StandardException {
        if (!this.usingNoneAuth && this.privilegedGetLCC().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        transactionResourceImpl.getDatabase().failover(transactionResourceImpl.getDBName());
    }

    private void handleFailoverSlave(Database database) throws SQLException {
        try {
            database.failover(this.getTR().getDBName());
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private Properties removePhaseTwoProps(Properties properties) {
        properties.remove("dataEncryption");
        properties.remove("decryptDatabase");
        properties.remove("newBootPassword");
        properties.remove("newEncryptionKey");
        properties.remove("upgrade");
        return properties;
    }

    public EmbedConnection(EmbedConnection embedConnection) {
        this.autoCommit = false;
        this.tr = null;
        this.active = true;
        this.rootConnection = embedConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = embedConnection.factory;
        this.connectionHoldAbility = embedConnection.connectionHoldAbility;
    }

    private void checkUserCredentials(boolean bl, String string, Properties properties) throws SQLException {
        AuthenticationService authenticationService = null;
        try {
            authenticationService = string == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        if (authenticationService == null) {
            String string2 = MessageService.getTextMessage(string == null ? "A001" : "A002", new Object[0]);
            throw EmbedConnection.newSQLException("08004", string2);
        }
        if (bl && this.compareDatabaseNames(this.getDBName(), authenticationService.getSystemCredentialsDatabaseName())) {
            String string3 = properties.getProperty("user");
            String string4 = properties.getProperty("password");
            if (this.emptyCredential(string3) || this.emptyCredential(string4)) {
                throw EmbedConnection.newSQLException("08004.C.13", new Object[0]);
            }
            return;
        }
        if (string != null) {
            this.checkUserIsNotARole();
        }
        boolean bl2 = true;
        try {
            bl2 = authenticationService.authenticate(string, properties);
        }
        catch (SQLWarning sQLWarning) {
            this.addWarning(sQLWarning);
        }
        if (!bl2) {
            throw EmbedConnection.newSQLException("08004.C.1", MessageService.getTextMessage("A020", new Object[0]));
        }
        if (authenticationService instanceof NoneAuthenticationServiceImpl) {
            this.usingNoneAuth = true;
        }
    }

    private boolean emptyCredential(String string) {
        return string == null || string.length() == 0;
    }

    private boolean compareDatabaseNames(String string, String string2) throws SQLException {
        try {
            String string3 = EmbedConnection.getMonitor().getCanonicalServiceName(string);
            String string4 = EmbedConnection.getMonitor().getCanonicalServiceName(string2);
            if (string3 == null) {
                return false;
            }
            return string3.equals(string4);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private void checkUserIsNotARole() throws SQLException {
        TransactionResourceImpl transactionResourceImpl = this.getTR();
        try {
            transactionResourceImpl.startTransaction();
            LanguageConnectionContext languageConnectionContext = transactionResourceImpl.getLcc();
            String string = languageConnectionContext.getSessionUserId();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            if (languageConnectionContext.usesSqlAuthorization() && dataDictionary.checkVersion(160, null)) {
                TransactionController transactionController = languageConnectionContext.getTransactionExecute();
                String string2 = MessageService.getTextMessage("A020", new Object[0]);
                if (dataDictionary.getRoleDefinitionDescriptor(string) != null) {
                    throw EmbedConnection.newSQLException("08004.C.1", string2);
                }
            }
            transactionResourceImpl.rollback();
            InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
        }
        catch (StandardException standardException) {
            try {
                transactionResourceImpl.rollback();
            }
            catch (StandardException standardException2) {
                // empty catch block
            }
            throw this.handleException(standardException);
        }
    }

    private void checkIsDBOwner(int n) throws SQLException {
        String string;
        LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
        String string2 = languageConnectionContext.getSessionUserId();
        if (!string2.equals(string = languageConnectionContext.getDataDictionary().getAuthorizationDatabaseOwner())) {
            switch (n) {
                case 0: {
                    throw EmbedConnection.newSQLException("08004.C.5", string2, this.tr.getDBName());
                }
                case 4: {
                    throw EmbedConnection.newSQLException("08004.C.14", string2, this.tr.getDBName());
                }
                case 1: {
                    throw EmbedConnection.newSQLException("08004.C.4", string2, this.tr.getDBName());
                }
                case 2: {
                    throw EmbedConnection.newSQLException("08004.C.6", string2, this.tr.getDBName());
                }
                case 3: {
                    throw EmbedConnection.newSQLException("08004.C.8", string2, this.tr.getDBName());
                }
            }
            throw EmbedConnection.newSQLException("08004.C.3", new Object[0]);
        }
    }

    public int getEngineType() {
        Database database = this.getDatabase();
        if (null == database) {
            return 0;
        }
        return database.getEngineType();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility);
    }

    @Override
    public final Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.connectionHoldAbility);
    }

    @Override
    public final Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(n), n2, n3);
    }

    @Override
    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, 2, null, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.connectionHoldAbility, 2, null, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareStatement(string, n, n2, n3, 2, null, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, nArray == null || nArray.length == 0 ? 2 : 1, nArray, null);
    }

    @Override
    public final PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, stringArray == null || stringArray.length == 0 ? 2 : 1, null, stringArray);
    }

    @Override
    public final PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String string, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            PreparedStatement preparedStatement;
            this.setupContextStack();
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, string, false, this.setResultSetType(n), n2, n3, n4, nArray, stringArray);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return preparedStatement;
        }
    }

    @Override
    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, this.connectionHoldAbility);
    }

    @Override
    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.connectionHoldAbility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            CallableStatement callableStatement;
            this.setupContextStack();
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, string, this.setResultSetType(n), n2, n3);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkIfClosed();
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && bl) {
            throw EmbedConnection.newSQLException("XJ030.S", new Object[0]);
        }
        if (this.autoCommit != bl) {
            this.commit();
        }
        this.autoCommit = bl;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().commit();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().rollback();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkForTransactionInProgress();
        this.close(exceptionClose);
    }

    public void checkForTransactionInProgress() throws SQLException {
        if (!(this.isClosed() || this.rootConnection != this || this.autoCommit || this.transactionIsIdle())) {
            Util.logAndThrowSQLException(EmbedConnection.newSQLException("25001", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(StandardException standardException) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rootConnection == this && (this.active || this.isAborting())) {
                if (this.tr.isActive()) {
                    this.setupContextStack();
                    try {
                        this.tr.rollback();
                        InterruptStatus.restoreIntrFlagIfSeen(this.tr.getLcc());
                        this.tr.clearLcc();
                        this.tr.cleanupOnError(standardException, false);
                    }
                    catch (Throwable throwable) {
                        throw this.handleException(throwable);
                    }
                    finally {
                        this.restoreContextStack();
                    }
                } else {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    this.tr.clearLcc();
                    this.tr.cleanupOnError(standardException, false);
                }
            }
            this.aborting = false;
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return !this.active || !this.getTR().isActive();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    @Override
    public final int getHoldability() throws SQLException {
        this.checkIfClosed();
        return this.connectionHoldAbility;
    }

    @Override
    public final void setHoldability(int n) throws SQLException {
        this.checkIfClosed();
        this.connectionHoldAbility = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReadOnly(boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                languageConnectionContext.setReadOnly(bl);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        return this.privilegedGetLCC().isReadOnly();
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkIfClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        int n2;
        if (n == this.getTransactionIsolation()) {
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                throw EmbedConnection.newSQLException("XJ045.S", n);
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                languageConnectionContext.setIsolationLevel(n2);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        return TransactionControl.jdbcIsolationLevel(this.privilegedGetLCC().getCurrentIsolationLevel());
    }

    @Override
    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.topWarning;
    }

    @Override
    public final synchronized void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.topWarning = null;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        if (map == null) {
            throw EmbedConnection.newSQLException("XJ081.S", map, "map", "java.sql.Connection.setTypeMap");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
    }

    @Override
    public final synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.topWarning == null) {
            this.topWarning = sQLWarning;
            return;
        }
        this.topWarning.setNextWarning(sQLWarning);
    }

    public String getDBName() {
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return this.privilegedGetLCC();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    SQLException handleException(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(throwable, this.autoCommit, true);
    }

    final SQLException handleException(Throwable throwable, boolean bl) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(throwable, this.autoCommit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.active = false;
            this.dbMetadata = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.rootConnection == this) {
                this.close(exceptionClose);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            this.needCommit = false;
        }
    }

    protected void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            this.needCommit = false;
        }
    }

    protected final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    protected final void setupContextStack() throws SQLException {
        if (!this.isAborting()) {
            this.checkIfClosed();
        }
        this.getTR().setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        TransactionResourceImpl transactionResourceImpl = this.getTR();
        transactionResourceImpl.restoreContextStack();
    }

    private Database createDatabase(String string, Properties properties) throws SQLException {
        properties = this.filterProperties(properties);
        try {
            if (EmbedConnection.createPersistentService("org.apache.derby.database.Database", string, properties) == null) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J01", string));
            }
        }
        catch (StandardException standardException) {
            throw Util.seeNextException("XJ041.C", this.handleException(standardException), standardException, string);
        }
        properties.clear();
        return (Database)EmbedConnection.findService("org.apache.derby.database.Database", string);
    }

    private void checkDatabaseCreatePrivileges(String string, String string2) throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        if (string2 == null) {
            throw new NullPointerException("dbname can't be null");
        }
        try {
            String string3 = "directory:" + EmbedConnection.stripSubSubProtocolPrefix(string2);
            DatabasePermission databasePermission = new DatabasePermission(string3, "create");
            this.factory.checkSystemPrivileges(string, databasePermission);
        }
        catch (AccessControlException accessControlException) {
            throw EmbedConnection.newSQLException("08004.C.11", string, string2, accessControlException);
        }
        catch (IOException iOException) {
            throw EmbedConnection.newSQLException("08004.C.10", string2, iOException);
        }
        catch (Exception exception) {
            throw EmbedConnection.newSQLException("08004.C.10", string2, exception);
        }
    }

    private static void sleep(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        while (l3 < l) {
            try {
                Thread.sleep(l - l3);
                break;
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
                l3 = System.currentTimeMillis() - l2;
            }
        }
    }

    public static String stripSubSubProtocolPrefix(String string) {
        String string2;
        int n = string.indexOf(58);
        if (n > 0 && PropertyUtil.getSystemProperty(string2 = "derby.subSubProtocol." + string.substring(0, n), null) != null) {
            return string.substring(n + 1);
        }
        return string;
    }

    private boolean bootDatabase(Properties properties, boolean bl) throws Throwable {
        String string = this.tr.getDBName();
        try {
            properties = this.filterProperties(properties);
            if (bl) {
                properties.setProperty("softUpgradeNoFeatureCheck", "true");
            } else {
                properties.remove("softUpgradeNoFeatureCheck");
            }
            if (!EmbedConnection.startPersistentService(string, properties)) {
                return false;
            }
            properties.clear();
            Database database = (Database)EmbedConnection.findService("org.apache.derby.database.Database", string);
            this.tr.setDatabase(database);
        }
        catch (StandardException standardException) {
            Throwable throwable = standardException.getCause();
            SQLException sQLException = throwable instanceof StandardException ? Util.generateCsSQLException((StandardException)throwable) : (throwable != null ? Util.javaException(throwable) : Util.generateCsSQLException(standardException));
            throw Util.seeNextException("XJ040.C", sQLException, throwable == null ? standardException : throwable, string, this.getClass().getClassLoader());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareMetaDataStatement(String string) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, string, true, 1003, 1007, this.connectionHoldAbility, 2, null, null);
            }
            finally {
                InterruptStatus.restoreIntrFlagIfSeen(this.privilegedGetLCC());
                this.restoreContextStack();
            }
            return preparedStatement;
        }
    }

    public final InternalDriver getLocalDriver() {
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("derby.")) continue;
            properties2.put(string, properties.getProperty(string));
        }
        return properties2;
    }

    protected Database getDatabase() {
        return this.getTR().getDatabase();
    }

    protected final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager contextManager) {
        return new EmbedConnectionContext(contextManager, this);
    }

    public final void setApplicationConnection(Connection connection) {
        this.applicationConnection = connection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    @Override
    public void setDrdaID(String string) {
        this.privilegedGetLCC().setDrdaID(string);
    }

    @Override
    public boolean isInGlobalTransaction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFromPool() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                languageConnectionContext.resetFromPool();
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                XATransactionController xATransactionController = (XATransactionController)languageConnectionContext.getTransactionExecute();
                try {
                    languageConnectionContext.checkIntegrity();
                }
                catch (StandardException standardException) {
                    languageConnectionContext.xaRollback();
                    throw standardException;
                }
                int n = xATransactionController.xa_prepare();
                if (n == 1) {
                    languageConnectionContext.internalCommit(false);
                }
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                int n2 = n;
                return n2;
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                languageConnectionContext.xaCommit(bl);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                languageConnectionContext.xaRollback();
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int n) {
        if (n == 1005) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01J02", new Object[0]));
            n = 1004;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrepareIsolation(int n) throws SQLException {
        if (n == this.getPrepareIsolation()) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw EmbedConnection.newSQLException("XJ045.S", n);
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.privilegedGetLCC().setPrepareIsolationLevel(n);
        }
    }

    @Override
    public int getPrepareIsolation() {
        return this.privilegedGetLCC().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    static SQLException newSQLException(String string, Object ... objectArray) {
        return Util.generateCsSQLException(string, objectArray);
    }

    public String toString() {
        if (this.connString == null) {
            LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "(XID = " + languageConnectionContext.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + Integer.toString(languageConnectionContext.getInstanceNumber()) + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + ") ";
        }
        return this.connString;
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkIfClosed();
        return new EmbedClob(this);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkIfClosed();
        return new EmbedBlob(new byte[0], this);
    }

    public int addLOBMapping(Object object) {
        int n = this.getIncLOBKey();
        this.getlobHMObj().put(n, object);
        return n;
    }

    public void removeLOBMapping(int n) {
        this.getlobHMObj().remove(n);
    }

    @Override
    public Object getLOBMapping(int n) {
        return this.getlobHMObj().get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLOBMapping() throws SQLException {
        Object object;
        WeakHashMap<Object, Object> weakHashMap = this.rootConnection.lobReferences;
        if (weakHashMap != null) {
            object = weakHashMap.keySet().iterator();
            while (object.hasNext()) {
                ((EngineLOB)object.next()).free();
            }
            weakHashMap.clear();
        }
        if (this.rootConnection.lobHashMap != null) {
            this.rootConnection.lobHashMap.clear();
        }
        object = this;
        synchronized (object) {
            if (this.lobFiles != null) {
                SQLException sQLException = null;
                Iterator<LOBFile> iterator2 = this.lobFiles.iterator();
                while (iterator2.hasNext()) {
                    try {
                        iterator2.next().close();
                    }
                    catch (IOException iOException) {
                        if (sQLException != null) continue;
                        sQLException = Util.javaException(iOException);
                    }
                }
                this.lobFiles.clear();
                if (sQLException != null) {
                    throw sQLException;
                }
            }
        }
    }

    private int getIncLOBKey() {
        int n;
        if ((n = ++this.rootConnection.lobHMKey) == 32768 || n == 32770 || n == 32772 || n == 32774 || n == 32776) {
            n = ++this.rootConnection.lobHMKey;
        }
        if (n == Integer.MIN_VALUE || n == 0) {
            this.rootConnection.lobHMKey = 1;
            n = 1;
        }
        return n;
    }

    void addLOBReference(Object object) {
        if (this.rootConnection.lobReferences == null) {
            this.rootConnection.lobReferences = new WeakHashMap();
        }
        this.rootConnection.lobReferences.put(object, null);
    }

    private HashMap<Integer, Object> getlobHMObj() {
        if (this.rootConnection.lobHashMap == null) {
            this.rootConnection.lobHashMap = new HashMap();
        }
        return this.rootConnection.lobHashMap;
    }

    public void cancelRunningStatement() {
        this.privilegedGetLCC().getStatementContext().cancel();
    }

    @Override
    public String getCurrentSchemaName() {
        return this.privilegedGetLCC().getCurrentSchemaName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLobFile(LOBFile lOBFile) {
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            if (this.lobFiles == null) {
                this.lobFiles = new HashSet();
            }
            this.lobFiles.add(lOBFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLobFile(LOBFile lOBFile) {
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            this.lobFiles.remove(lOBFile);
        }
    }

    public boolean isAborting() {
        return this.aborting;
    }

    protected void beginAborting() {
        this.aborting = true;
        this.setInactive();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.commonSetSavepointCode(null, false);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this.commonSetSavepointCode(string, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Savepoint commonSetSavepointCode(String string, boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                EmbedSavepoint embedSavepoint;
                this.verifySavepointCommandIsAllowed();
                if (bl && string == null) {
                    throw EmbedConnection.newSQLException("XJ011.S", new Object[0]);
                }
                if (bl && string.length() > 128) {
                    throw EmbedConnection.newSQLException("42622", string, String.valueOf(128));
                }
                if (bl && string.startsWith("SYS")) {
                    throw EmbedConnection.newSQLException("42939", "SYS");
                }
                EmbedSavepoint embedSavepoint2 = embedSavepoint = new EmbedSavepoint(this, string);
                return embedSavepoint2;
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.privilegedGetLCC().internalRollbackToSavepoint(((EmbedSavepoint)savepoint).getInternalName(), true, savepoint);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.privilegedGetLCC().releaseSavePoint(((EmbedSavepoint)savepoint).getInternalName(), savepoint);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    private void verifySavepointCommandIsAllowed() throws SQLException {
        if (this.autoCommit) {
            throw EmbedConnection.newSQLException("XJ010.S", new Object[0]);
        }
        StatementContext statementContext = this.privilegedGetLCC().getStatementContext();
        if (statementContext != null && statementContext.inTrigger()) {
            throw EmbedConnection.newSQLException("XJ017.S", new Object[0]);
        }
    }

    private void verifySavepointArg(Savepoint savepoint) throws SQLException {
        EmbedSavepoint embedSavepoint = (EmbedSavepoint)savepoint;
        if (embedSavepoint == null) {
            throw EmbedConnection.newSQLException("3B001.S", "null");
        }
        if (!embedSavepoint.sameConnection(this)) {
            throw EmbedConnection.newSQLException("3B502.S", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            String string;
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.privilegedGetLCC();
                string = languageConnectionContext.getCurrentSchemaName();
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return string;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkIfClosed();
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.prepareStatement("set schema ?");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
    }

    private void checkConflictingCryptoAttributes(Properties properties) throws SQLException {
        boolean bl;
        boolean bl2 = bl = EmbedConnection.isSet(properties, "encryptionKey") || EmbedConnection.isSet(properties, "bootPassword");
        if (bl && EmbedConnection.isTrue(properties, "decryptDatabase")) {
            if (EmbedConnection.isSet(properties, "newBootPassword")) {
                throw EmbedConnection.newSQLException("XJ048.C", "decryptDatabase, newBootPassword");
            }
            if (EmbedConnection.isSet(properties, "newEncryptionKey")) {
                throw EmbedConnection.newSQLException("XJ048.C", "decryptDatabase, newEncryptionKey");
            }
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw EmbedConnection.newSQLException("XJ081.S", n, "timeout", "java.sql.Connection.isValid");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        Properties properties = FailedProperties40.makeProperties(string, string2);
        try {
            this.checkIfClosed();
        }
        catch (SQLException sQLException) {
            FailedProperties40 failedProperties40 = new FailedProperties40(properties);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), failedProperties40.getProperties());
        }
        if (string == null && string2 == null) {
            return;
        }
        this.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 failedProperties40 = new FailedProperties40(properties);
        try {
            this.checkIfClosed();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), failedProperties40.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        StandardException standardException = StandardException.newException("XCY02.S", failedProperties40.getFirstKey(), failedProperties40.getFirstValue());
        throw new SQLClientInfoException(standardException.getMessage(), standardException.getSQLState(), standardException.getErrorCode(), failedProperties40.getProperties());
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkIfClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfClosed();
        return new Properties();
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfClosed();
        return Collections.emptyMap();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkIfClosed();
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkIfClosed();
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw EmbedConnection.newSQLException("XJ128.S", clazz);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (executor == null) {
            throw EmbedConnection.newSQLException("XCZ02.S", "executor", "null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SQLPermission("callAbort"));
        }
        this.beginAborting();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbedConnection.this.rollback();
                    EmbedConnection.this.close(exceptionClose);
                }
                catch (SQLException sQLException) {
                    Util.logSQLException(sQLException);
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw Util.notImplemented();
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object findService(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.findService(string, string2);
            }
        });
    }

    private static boolean startPersistentService(final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return Monitor.startPersistentService(string, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static Object createPersistentService(final String string, final String string2, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.createPersistentService(string, string2, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static void removePersistentService(final String string) throws StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    Monitor.removePersistentService(string);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private LanguageConnectionContext privilegedGetLCC() {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return EmbedConnection.this.getTR().getLcc();
            }
        });
    }
}

