/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.services.daemon.ServiceRecord;

public class BasicDaemon
implements DaemonService,
Runnable {
    private int numClients;
    private static final int OPTIMAL_QUEUE_SIZE = 100;
    private final Vector<ServiceRecord> subscription;
    protected final ContextService contextService;
    protected final ContextManager contextMgr;
    private final List<ServiceRecord> highPQ;
    private final List<ServiceRecord> normPQ;
    private int nextService;
    private boolean awakened;
    private boolean waiting;
    private boolean inPause;
    private boolean running;
    private boolean stopRequested;
    private boolean stopped;
    private long lastServiceTime;
    private int earlyWakeupCount;

    public BasicDaemon(ContextService contextService) {
        this.contextService = contextService;
        this.contextMgr = contextService.newContextManager();
        this.subscription = new Vector(1, 1);
        this.highPQ = new LinkedList<ServiceRecord>();
        this.normPQ = new LinkedList<ServiceRecord>();
        this.lastServiceTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subscribe(Serviceable serviceable, boolean bl) {
        int n;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            n = this.numClients++;
            ServiceRecord serviceRecord = new ServiceRecord(serviceable, bl, true);
            this.subscription.add(n, serviceRecord);
        }
        return n;
    }

    @Override
    public void unsubscribe(int n) {
        if (n < 0 || n > this.subscription.size()) {
            return;
        }
        this.subscription.set(n, null);
    }

    @Override
    public void serviceNow(int n) {
        if (n < 0 || n > this.subscription.size()) {
            return;
        }
        ServiceRecord serviceRecord = this.subscription.get(n);
        if (serviceRecord == null) {
            return;
        }
        serviceRecord.called();
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(Serviceable serviceable, boolean bl) {
        int n;
        ServiceRecord serviceRecord = new ServiceRecord(serviceable, false, false);
        List<ServiceRecord> list = bl ? this.highPQ : this.normPQ;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            list.add(serviceRecord);
            n = this.highPQ.size();
        }
        if (bl && !this.awakened) {
            this.wakeUp();
        }
        if (bl) {
            return n > 100;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.normPQ.clear();
        this.highPQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRecord nextAssignment(boolean bl) {
        ServiceRecord serviceRecord;
        while (this.nextService < this.subscription.size()) {
            if ((serviceRecord = this.subscription.get(this.nextService++)) == null || !serviceRecord.needImmediateService() && (bl || !serviceRecord.needService())) continue;
            return serviceRecord;
        }
        serviceRecord = null;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.highPQ.isEmpty()) {
                serviceRecord = this.highPQ.remove(0);
            }
        }
        if (bl || serviceRecord != null) {
            return serviceRecord;
        }
        serviceRecord = null;
        basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.normPQ.isEmpty()) {
                serviceRecord = this.normPQ.remove(0);
            }
        }
        return serviceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceClient(ServiceRecord serviceRecord) {
        serviceRecord.serviced();
        Serviceable serviceable = serviceRecord.client;
        if (serviceable == null) {
            return;
        }
        ContextManager contextManager = this.contextMgr;
        try {
            int n = serviceable.performWork(contextManager);
            if (serviceRecord.subscriber) {
                return;
            }
            if (n == 2) {
                List<ServiceRecord> list = serviceable.serviceASAP() ? this.highPQ : this.normPQ;
                BasicDaemon basicDaemon = this;
                synchronized (basicDaemon) {
                    list.add(serviceRecord);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            contextManager.cleanupOnError(throwable, false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.contextService.setCurrentContextManager(this.contextMgr);
        while (!this.stopRequested()) {
            boolean bl = this.rest();
            if (this.stopRequested()) break;
            if (this.inPause()) continue;
            this.work(bl);
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.running = false;
            this.stopped = true;
        }
        this.contextMgr.cleanupOnError(StandardException.normalClose(), false);
        this.contextService.resetCurrentContextManager(this.contextMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = true;
            while (this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.stopRequested = true;
            this.notifyAll();
        }
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilQueueIsEmpty() {
        while (true) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                boolean bl = true;
                for (int i = 0; i < this.subscription.size(); ++i) {
                    ServiceRecord serviceRecord = this.subscription.get(i);
                    if (serviceRecord == null || !serviceRecord.needService()) continue;
                    bl = false;
                    break;
                }
                if (this.highPQ.isEmpty() && bl && !this.running) {
                    return;
                }
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
        }
    }

    private synchronized boolean stopRequested() {
        return this.stopRequested;
    }

    private synchronized boolean inPause() {
        return this.inPause;
    }

    protected synchronized void wakeUp() {
        if (!this.awakened) {
            this.awakened = true;
            if (this.waiting) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rest() {
        long l;
        boolean bl;
        boolean bl2 = false;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            try {
                if (!this.awakened) {
                    this.waiting = true;
                    this.wait(10000L);
                    this.waiting = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextService = 0;
            bl = this.awakened;
            if (bl && this.earlyWakeupCount++ > 20) {
                this.earlyWakeupCount = 0;
                bl2 = true;
            }
            this.awakened = false;
        }
        if (bl2 && (l = System.currentTimeMillis()) - this.lastServiceTime > 10000L) {
            this.lastServiceTime = l;
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(boolean bl) {
        int n = 0;
        int n2 = 10;
        if (bl && this.highPQ.size() > 100) {
            n2 = 2;
        }
        int n3 = 100 / n2;
        ServiceRecord serviceRecord = this.nextAssignment(bl);
        while (serviceRecord != null) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                if (this.inPause || this.stopRequested) {
                    break;
                }
                this.running = true;
            }
            try {
                this.serviceClient(serviceRecord);
            }
            finally {
                basicDaemon = this;
                synchronized (basicDaemon) {
                    this.running = false;
                    this.notifyAll();
                    if (this.inPause || this.stopRequested) {
                        break;
                    }
                }
            }
            if (++n % 50 == 0) {
                this.nextService = 0;
            }
            if (n % n3 == 0) {
                this.yield();
            }
            serviceRecord = this.nextAssignment(bl);
        }
    }

    private void yield() {
        Thread thread2 = Thread.currentThread();
        int n = thread2.getPriority();
        if (n <= 1) {
            Thread.yield();
        } else {
            ModuleFactory moduleFactory = BasicDaemon.getMonitor();
            BasicDaemon.setThreadPriority(moduleFactory, 1);
            Thread.yield();
            BasicDaemon.setThreadPriority(moduleFactory, n);
        }
    }

    private static void setThreadPriority(ModuleFactory moduleFactory, final int n) {
        final Thread thread2 = Thread.currentThread();
        if (moduleFactory != null && moduleFactory.isDaemonThread(thread2)) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread2.setPriority(n);
                    return null;
                }
            });
        }
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

