/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.impl.services.daemon.BasicDaemon;

public class SingleThreadDaemonFactory
implements DaemonFactory {
    private final ContextService contextService = SingleThreadDaemonFactory.getContextService();

    @Override
    public DaemonService createNewDaemon(String string) {
        BasicDaemon basicDaemon = new BasicDaemon(this.contextService);
        final Thread thread2 = BasicDaemon.getMonitor().getDaemonThread(basicDaemon, string, false);
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    thread2.setContextClassLoader(null);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        thread2.start();
        return basicDaemon;
    }

    private static ContextService getContextService() {
        if (System.getSecurityManager() == null) {
            return ContextService.getFactory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }
}

