/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class XPLAINSystemTableVisitor
implements XPLAINVisitor {
    private boolean no_call_stmts = true;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private Activation activation;
    private boolean considerTimingInformation = false;
    private XPLAINStatementDescriptor stmt;
    private XPLAINStatementTimingsDescriptor stmtTimings = null;
    private UUID stmtUUID;
    private List<XPLAINResultSetDescriptor> rsets = new ArrayList<XPLAINResultSetDescriptor>();
    private List<Object> rsetsTimings = new ArrayList<Object>();
    private List<XPLAINSortPropsDescriptor> sortrsets = new ArrayList<XPLAINSortPropsDescriptor>();
    private List<XPLAINScanPropsDescriptor> scanrsets = new ArrayList<XPLAINScanPropsDescriptor>();
    private int noChildren;
    private Stack<UUID> UUIDStack = new Stack();

    private void pushUUIDnoChildren(UUID uUID) {
        for (int i = 0; i < this.noChildren; ++i) {
            this.UUIDStack.push(uUID);
        }
    }

    @Override
    public void setNumberOfChildren(int n) {
        this.noChildren = n;
    }

    @Override
    public void visit(ResultSetStatistics resultSetStatistics) {
        UUID uUID;
        XPLAINSortPropsDescriptor xPLAINSortPropsDescriptor;
        UUID uUID2 = null;
        if (this.considerTimingInformation) {
            uUID2 = this.dd.getUUIDFactory().createUUID();
            this.rsetsTimings.add(resultSetStatistics.getResultSetTimingsDescriptor(uUID2));
        }
        if ((xPLAINSortPropsDescriptor = (XPLAINSortPropsDescriptor)resultSetStatistics.getSortPropsDescriptor(uUID = this.dd.getUUIDFactory().createUUID())) != null) {
            this.sortrsets.add(xPLAINSortPropsDescriptor);
        } else {
            uUID = null;
        }
        UUID uUID3 = this.dd.getUUIDFactory().createUUID();
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = (XPLAINScanPropsDescriptor)resultSetStatistics.getScanPropsDescriptor(uUID3);
        if (xPLAINScanPropsDescriptor != null) {
            this.scanrsets.add(xPLAINScanPropsDescriptor);
        } else {
            uUID3 = null;
        }
        UUID uUID4 = this.dd.getUUIDFactory().createUUID();
        this.rsets.add((XPLAINResultSetDescriptor)resultSetStatistics.getResultSetDescriptor(uUID4, this.UUIDStack.empty() ? (UUID)null : this.UUIDStack.pop(), uUID3, uUID, this.stmtUUID, uUID2));
        this.pushUUIDnoChildren(uUID4);
    }

    @Override
    public void reset() {
        this.lcc = this.activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
    }

    @Override
    public void doXPLAIN(RunTimeStatistics runTimeStatistics, Activation activation) throws StandardException {
        Object object;
        Object object2;
        this.activation = activation;
        this.reset();
        this.considerTimingInformation = this.lcc.getStatisticsTiming();
        UUID uUID = null;
        if (this.considerTimingInformation) {
            uUID = this.dd.getUUIDFactory().createUUID();
            object2 = runTimeStatistics.getEndExecutionTimestamp();
            object = runTimeStatistics.getBeginExecutionTimestamp();
            long l = object2 != null && object != null ? ((Timestamp)object2).getTime() - ((Timestamp)object).getTime() : 0L;
            this.stmtTimings = new XPLAINStatementTimingsDescriptor(uUID, runTimeStatistics.getParseTimeInMillis(), runTimeStatistics.getBindTimeInMillis(), runTimeStatistics.getOptimizeTimeInMillis(), runTimeStatistics.getGenerateTimeInMillis(), runTimeStatistics.getCompileTimeInMillis(), l, runTimeStatistics.getBeginCompilationTimestamp(), runTimeStatistics.getEndCompilationTimestamp(), runTimeStatistics.getBeginExecutionTimestamp(), runTimeStatistics.getEndExecutionTimestamp());
        }
        this.stmtUUID = this.dd.getUUIDFactory().createUUID();
        object2 = XPLAINUtil.getStatementType(runTimeStatistics.getStatementText());
        if (((String)object2).equalsIgnoreCase("C") && this.no_call_stmts) {
            return;
        }
        object = this.lcc.getTransactionExecute().getTransactionIdString();
        String string = Integer.toString(this.lcc.getInstanceNumber());
        String string2 = Integer.toString(JVMInfo.JDK_ID);
        String string3 = System.getProperty("os.name");
        long l = System.currentTimeMillis();
        String string4 = this.lcc.getXplainOnlyMode() ? "O" : "F";
        Timestamp timestamp = new Timestamp(l);
        String string5 = Thread.currentThread().toString();
        this.stmt = new XPLAINStatementDescriptor(this.stmtUUID, runTimeStatistics.getStatementName(), (String)object2, runTimeStatistics.getStatementText(), string2, string3, string4, timestamp, string5, (String)object, string, this.lcc.getDbname(), this.lcc.getDrdaID(), uUID);
        try {
            this.addStmtDescriptorsToSystemCatalog();
            runTimeStatistics.acceptFromTopResultSet(this);
            this.addArraysToSystemCatalogs();
        }
        catch (SQLException sQLException) {
            throw StandardException.plainWrapException(sQLException);
        }
        this.clean();
    }

    private void clean() {
        this.activation = null;
        this.lcc = null;
        this.dd = null;
        this.stmtUUID = null;
        this.stmt = null;
        this.stmtTimings = null;
        this.rsets.clear();
        this.rsetsTimings.clear();
        this.sortrsets.clear();
        this.scanrsets.clear();
        this.UUIDStack.clear();
    }

    private Connection getDefaultConn() throws SQLException {
        ConnectionContext connectionContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
        return connectionContext.getNestedConnection(true);
    }

    private void addStmtDescriptorsToSystemCatalog() throws StandardException, SQLException {
        boolean bl = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(false);
        Connection connection = this.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_STATEMENTS"));
        this.stmt.setStatementParameters(preparedStatement);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        if (this.considerTimingInformation) {
            preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_STATEMENT_TIMINGS"));
            this.stmtTimings.setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        connection.close();
        this.lcc.setRunTimeStatisticsMode(bl);
    }

    private void addArraysToSystemCatalogs() throws StandardException, SQLException {
        boolean bl = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(false);
        Connection connection = this.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_RESULTSETS"));
        for (XPLAINResultSetDescriptor iterator2 : this.rsets) {
            iterator2.setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        if (this.considerTimingInformation) {
            preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_RESULTSET_TIMINGS"));
            for (XPLAINResultSetTimingsDescriptor xPLAINResultSetTimingsDescriptor : this.rsetsTimings) {
                xPLAINResultSetTimingsDescriptor.setStatementParameters(preparedStatement);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
        }
        preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_SCAN_PROPS"));
        for (XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor : this.scanrsets) {
            xPLAINScanPropsDescriptor.setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_SORT_PROPS"));
        for (XPLAINSortPropsDescriptor xPLAINSortPropsDescriptor : this.sortrsets) {
            xPLAINSortPropsDescriptor.setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.close();
        this.lcc.setRunTimeStatisticsMode(bl);
    }
}

