/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DataInputUtil;

public final class StoredFieldHeader {
    private static final int FIELD_INITIAL = 0;
    public static final int FIELD_NULL = 1;
    public static final int FIELD_OVERFLOW = 2;
    private static final int FIELD_NOT_NULLABLE = 4;
    public static final int FIELD_EXTENSIBLE = 8;
    public static final int FIELD_TAGGED = 16;
    protected static final int FIELD_FIXED = 32;
    public static final int FIELD_NONEXISTENT = 5;
    public static final int STORED_FIELD_HEADER_STATUS_SIZE = 1;

    public static final boolean isNull(int n) {
        return (n & 1) == 1;
    }

    public static final boolean isOverflow(int n) {
        return (n & 2) == 2;
    }

    public static final boolean isNonexistent(int n) {
        return (n & 5) == 5;
    }

    public static final boolean isExtensible(int n) {
        return (n & 8) == 8;
    }

    public static final boolean isNullorNonExistent(int n) {
        return (n & 1) != 0;
    }

    public static final boolean isTagged(int n) {
        return (n & 0x10) == 16;
    }

    public static final boolean isFixed(int n) {
        return (n & 0x20) == 32;
    }

    public static final boolean isNullable(int n) {
        return (n & 4) == 0;
    }

    public static final int size(int n, int n2, int n3) {
        if ((n & 0x21) == 0) {
            if (n2 <= 63) {
                return 2;
            }
            if (n2 <= 16383) {
                return 3;
            }
            return 5;
        }
        if ((n & 1) != 0) {
            return 1;
        }
        return n3 > 2 ? 5 : 3;
    }

    public static final int setInitial() {
        return 0;
    }

    public static final int setNull(int n, boolean bl) {
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        return n;
    }

    public static final int setOverflow(int n, boolean bl) {
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        return n;
    }

    public static final int setNonexistent(int n) {
        return n |= 5;
    }

    public static final int setExtensible(int n, boolean bl) {
        n = bl ? (n |= 8) : (n &= 0xFFFFFFF7);
        return n;
    }

    public static final int setTagged(int n, boolean bl) {
        n = bl ? (n |= 0x10) : (n &= 0xFFFFFFEF);
        return n;
    }

    public static final int setFixed(int n, boolean bl) {
        n = bl ? (n |= 0x20) : (n &= 0xFFFFFFDF);
        return n;
    }

    public static final int write(OutputStream outputStream2, int n, int n2, int n3) throws IOException {
        int n4 = 1;
        outputStream2.write(n);
        if (StoredFieldHeader.isNull(n)) {
            return n4;
        }
        if (StoredFieldHeader.isFixed(n)) {
            if (n3 > 2) {
                int n5;
                for (int i = n5 = n3 - CompressedNumber.writeInt(outputStream2, n2); i > 0; --i) {
                    outputStream2.write(0);
                }
                n4 += n3;
            } else {
                outputStream2.write(n2 >>> 8 & 0xFF);
                outputStream2.write(n2 >>> 0 & 0xFF);
                n4 += 2;
            }
        } else {
            n4 += CompressedNumber.writeInt(outputStream2, n2);
        }
        return n4;
    }

    public static final int readStatus(ObjectInput objectInput) throws IOException {
        int n = objectInput.read();
        if (n >= 0) {
            return n;
        }
        throw new EOFException();
    }

    public static final int readStatus(byte[] byArray, int n) {
        return byArray[n];
    }

    public static final int readTotalFieldLength(byte[] byArray, int n) throws IOException {
        if ((byArray[n++] & 1) != 1) {
            byte by = byArray[n];
            if ((by & 0xFFFFFFC0) == 0) {
                return by + 2;
            }
            if ((by & 0x80) == 0) {
                return ((by & 0x3F) << 8 | byArray[n + 1] & 0xFF) + 3;
            }
            return ((by & 0x7F) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) + 5;
        }
        return 1;
    }

    public static final int readFieldLengthAndSetStreamPosition(byte[] byArray, int n, int n2, int n3, ArrayInputStream arrayInputStream) throws IOException {
        int n4;
        if ((n2 & 0x21) == 0) {
            int n5;
            if (((n5 = byArray[n++]) & 0xFFFFFFC0) != 0) {
                n5 = (n5 & 0x80) == 0 ? (n5 & 0x3F) << 8 | byArray[n++] & 0xFF : (n5 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            }
            arrayInputStream.setPosition(n);
            return n5;
        }
        if ((n2 & 1) != 0) {
            arrayInputStream.setPosition(n);
            return 0;
        }
        if (n3 <= 2) {
            n4 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        } else {
            n4 = byArray[n];
            if ((n4 & 0xFFFFFFC0) != 0) {
                n4 = (n4 & 0x80) == 0 ? (n4 & 0x3F) << 8 | byArray[n + 1] & 0xFF : (n4 & 0x7F) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            }
            n += n3;
        }
        arrayInputStream.setPosition(n);
        return n4;
    }

    public static final int readFieldDataLength(ObjectInput objectInput, int n, int n2) throws IOException {
        int n3;
        if ((n & 0x21) == 0) {
            return CompressedNumber.readInt(objectInput);
        }
        if ((n & 1) != 0) {
            return 0;
        }
        if (n2 <= 2) {
            int n4;
            int n5 = objectInput.read();
            if ((n5 | (n4 = objectInput.read())) < 0) {
                throw new EOFException();
            }
            n3 = (n5 << 8) + (n4 << 0);
        } else {
            n3 = CompressedNumber.readInt(objectInput);
            int n6 = n2 - CompressedNumber.sizeInt(n3);
            if (n6 != 0) {
                DataInputUtil.skipFully(objectInput, n6);
            }
        }
        return n3;
    }

    public static String toDebugString(int n) {
        return null;
    }
}

