/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitAnyDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitAnyKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIdentifierColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitMapKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitTenantIdColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.naming.NamingHelper;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;

public class ImplicitNamingStrategyJpaCompliantImpl
implements ImplicitNamingStrategy,
Serializable {
    public static final ImplicitNamingStrategy INSTANCE = new ImplicitNamingStrategyJpaCompliantImpl();

    @Override
    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source2) {
        if (source2 == null) {
            throw new HibernateException("Entity naming information was not provided.");
        }
        String tableName = this.transformEntityName(source2.getEntityNaming());
        if (tableName == null) {
            throw new HibernateException("Could not determine primary table name for entity");
        }
        return this.toIdentifier(tableName, source2.getBuildingContext());
    }

    protected String transformEntityName(EntityNaming entityNaming) {
        if (StringHelper.isNotEmpty(entityNaming.getJpaEntityName())) {
            return entityNaming.getJpaEntityName();
        }
        return StringHelper.unqualify(entityNaming.getEntityName());
    }

    @Override
    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source2) {
        String name = source2.getOwningPhysicalTableName() + '_' + source2.getNonOwningPhysicalTableName();
        return this.toIdentifier(name, source2.getBuildingContext());
    }

    @Override
    public Identifier determineCollectionTableName(ImplicitCollectionTableNameSource source2) {
        String entityName = this.transformEntityName(source2.getOwningEntityNaming());
        String name = entityName + '_' + this.transformAttributePath(source2.getOwningAttributePath());
        return this.toIdentifier(name, source2.getBuildingContext());
    }

    @Override
    public Identifier determineIdentifierColumnName(ImplicitIdentifierColumnNameSource source2) {
        return this.toIdentifier(this.transformAttributePath(source2.getIdentifierAttributePath()), source2.getBuildingContext());
    }

    @Override
    public Identifier determineDiscriminatorColumnName(ImplicitDiscriminatorColumnNameSource source2) {
        return this.toIdentifier(source2.getBuildingContext().getMappingDefaults().getImplicitDiscriminatorColumnName(), source2.getBuildingContext());
    }

    @Override
    public Identifier determineTenantIdColumnName(ImplicitTenantIdColumnNameSource source2) {
        return this.toIdentifier(source2.getBuildingContext().getMappingDefaults().getImplicitTenantIdColumnName(), source2.getBuildingContext());
    }

    @Override
    public Identifier determineBasicColumnName(ImplicitBasicColumnNameSource source2) {
        return this.toIdentifier(this.transformAttributePath(source2.getAttributePath()), source2.getBuildingContext());
    }

    @Override
    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source2) {
        String name = source2.getNature() == ImplicitJoinColumnNameSource.Nature.ELEMENT_COLLECTION || source2.getAttributePath() == null ? this.transformEntityName(source2.getEntityNaming()) + '_' + source2.getReferencedColumnName().getText() : this.transformAttributePath(source2.getAttributePath()) + '_' + source2.getReferencedColumnName().getText();
        return this.toIdentifier(name, source2.getBuildingContext());
    }

    @Override
    public Identifier determinePrimaryKeyJoinColumnName(ImplicitPrimaryKeyJoinColumnNameSource source2) {
        return source2.getReferencedPrimaryKeyColumnName();
    }

    @Override
    public Identifier determineAnyDiscriminatorColumnName(ImplicitAnyDiscriminatorColumnNameSource source2) {
        return this.toIdentifier(this.transformAttributePath(source2.getAttributePath()) + "_" + source2.getBuildingContext().getMappingDefaults().getImplicitDiscriminatorColumnName(), source2.getBuildingContext());
    }

    @Override
    public Identifier determineAnyKeyColumnName(ImplicitAnyKeyColumnNameSource source2) {
        return this.toIdentifier(this.transformAttributePath(source2.getAttributePath()) + "_" + source2.getBuildingContext().getMappingDefaults().getImplicitIdColumnName(), source2.getBuildingContext());
    }

    @Override
    public Identifier determineMapKeyColumnName(ImplicitMapKeyColumnNameSource source2) {
        return this.toIdentifier(this.transformAttributePath(source2.getPluralAttributePath()) + "_KEY", source2.getBuildingContext());
    }

    @Override
    public Identifier determineListIndexColumnName(ImplicitIndexColumnNameSource source2) {
        return this.toIdentifier(this.transformAttributePath(source2.getPluralAttributePath()) + "_ORDER", source2.getBuildingContext());
    }

    @Override
    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source2) {
        Identifier userProvidedIdentifier = source2.getUserProvidedIdentifier();
        return userProvidedIdentifier != null ? userProvidedIdentifier : this.toIdentifier(NamingHelper.withCharset(source2.getBuildingContext().getBuildingOptions().getSchemaCharset()).generateHashedFkName("FK", source2.getTableName(), source2.getReferencedTableName(), source2.getColumnNames()), source2.getBuildingContext());
    }

    @Override
    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source2) {
        Identifier userProvidedIdentifier = source2.getUserProvidedIdentifier();
        return userProvidedIdentifier != null ? userProvidedIdentifier : this.toIdentifier(NamingHelper.withCharset(source2.getBuildingContext().getBuildingOptions().getSchemaCharset()).generateHashedConstraintName("UK", source2.getTableName(), source2.getColumnNames()), source2.getBuildingContext());
    }

    @Override
    public Identifier determineIndexName(ImplicitIndexNameSource source2) {
        Identifier userProvidedIdentifier = source2.getUserProvidedIdentifier();
        return userProvidedIdentifier != null ? userProvidedIdentifier : this.toIdentifier(NamingHelper.withCharset(source2.getBuildingContext().getBuildingOptions().getSchemaCharset()).generateHashedConstraintName("IDX", source2.getTableName(), source2.getColumnNames()), source2.getBuildingContext());
    }

    protected String transformAttributePath(AttributePath attributePath) {
        return attributePath.getProperty();
    }

    protected Identifier toIdentifier(String stringForm, MetadataBuildingContext buildingContext) {
        return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(stringForm);
    }
}

