/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.jboss.logging.Logger;

public class OneToManyLoader
extends CollectionLoader {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, OneToManyLoader.class.getName());

    public OneToManyLoader(QueryableCollection oneToManyPersister, SessionFactoryImplementor session, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(oneToManyPersister, 1, session, loadQueryInfluencers);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, int batchSize, SessionFactoryImplementor factory2, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(oneToManyPersister, batchSize, null, factory2, loadQueryInfluencers);
    }

    public OneToManyLoader(QueryableCollection oneToManyPersister, int batchSize, String subquery, SessionFactoryImplementor factory2, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(oneToManyPersister, factory2, loadQueryInfluencers);
        OneToManyJoinWalker walker = new OneToManyJoinWalker(oneToManyPersister, batchSize, subquery, factory2, loadQueryInfluencers);
        this.initFromWalker(walker);
        this.postInstantiate();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for one-to-many %s: %s", (Object)oneToManyPersister.getRole(), (Object)this.getSQLString());
        }
    }
}

